package cat.minkusoft.sample

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.EditText
import androidx.core.os.bundleOf
import androidx.fragment.app.Fragment
import androidx.fragment.app.setFragmentResult
import androidx.navigation.fragment.findNavController

class TeamDefinitionFragment:Fragment() {
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_team_definition, container, false)

    }

    lateinit var txtName:EditText

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        txtName = view.findViewById(R.id.txtName)
        view.findViewById<Button>(R.id.btAccept).setOnClickListener {
            setFragmentResult(REQ_TEAM, bundleOf(Pair(RESULT_TEAM_NAME,txtName.text.toString())))
            findNavController().popBackStack()
        }
    }

    companion object {
        const val REQ_TEAM = "reqTeam"
        const val RESULT_TEAM_NAME = "resultTeamName"
    }
}