package cat.minkusoft.sample

import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.TextView
import androidx.fragment.app.clearFragmentResultListener
import androidx.fragment.app.setFragmentResultListener
import androidx.navigation.fragment.findNavController


/**
 * A simple [Fragment] subclass.
 * Use the [TeamsFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
class TeamsFragment : Fragment() {


    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_teams, container, false)
    }

    lateinit var buttons: List<Button>
    lateinit var texts: List<TextView>

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val btTeam1 = view.findViewById<Button>(R.id.btTeam1)
        val btTeam2 = view.findViewById<Button>(R.id.btTeam2)
        val btTeam3 = view.findViewById<Button>(R.id.btTeam3)
        val btTeam4 = view.findViewById<Button>(R.id.btTeam4)
        val txtTeam1 = view.findViewById<TextView>(R.id.txtTeam1)
        val txtTeam2 = view.findViewById<TextView>(R.id.txtTeam2)
        val txtTeam3 = view.findViewById<TextView>(R.id.txtTeam3)
        val txtTeam4 = view.findViewById<TextView>(R.id.txtTeam4)

        buttons = arrayListOf(btTeam1, btTeam2, btTeam3, btTeam4)
        texts = arrayListOf(txtTeam1, txtTeam2, txtTeam3, txtTeam4)

        buttons.forEachIndexed {index,button ->
            button.setOnClickListener {
                openEditFragment(index)
            }
        }
    }

    private fun openEditFragment(teamId: Int) {
        println("asking name for team $teamId")
        this.setFragmentResultListener(TeamDefinitionFragment.REQ_TEAM) { resultKey: String, bundle: Bundle ->
            if (resultKey == TeamDefinitionFragment.REQ_TEAM) {
                this.clearFragmentResultListener(TeamDefinitionFragment.REQ_TEAM) //this has no effect
                bundle.getString(TeamDefinitionFragment.RESULT_TEAM_NAME)?.let { teamName ->
                    println("'$teamName' received for team $teamId")
                    putName(teamId, teamName)
                }
            }
            this.clearFragmentResultListener(TeamDefinitionFragment.REQ_TEAM) //this has no effect neither, that's more weird
        }
        findNavController().navigate(R.id.action_main_dest_to_definition_dest)
    }

    private fun putName(teamId: Int, name:String) {
        texts.getOrNull(teamId)?.text = name
    }

}