package dev.olshevski.paging3sandbox

import android.util.Log
import android.view.LayoutInflater
import android.view.ViewGroup
import android.widget.TextView
import androidx.paging.PagingDataAdapter
import androidx.recyclerview.widget.DiffUtil
import androidx.recyclerview.widget.RecyclerView

class ItemPagingAdapter : PagingDataAdapter<Item, ItemPagingAdapter.ItemViewHolder>(DIFF_CALLBACK) {

    private companion object {
        private val DIFF_CALLBACK = object : DiffUtil.ItemCallback<Item>() {
            override fun areItemsTheSame(oldItem: Item, newItem: Item): Boolean =
                oldItem.id == newItem.id

            override fun areContentsTheSame(oldItem: Item, newItem: Item): Boolean =
                oldItem == newItem
        }
    }

    class ItemViewHolder(parent: ViewGroup) : RecyclerView.ViewHolder(
        LayoutInflater.from(parent.context).inflate(R.layout.item, parent, false)
    ) {
        private val text by lazy { itemView.findViewById<TextView>(R.id.text) }

        fun bind(item: Item) {
            text.text = item.text
        }
    }

    override fun onBindViewHolder(holder: ItemViewHolder, position: Int) {
        Log.v("ItemPagingAdapter", "position=$position itemCount=$itemCount")
        return holder.bind(getItem(position)!!)
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ItemViewHolder =
        ItemViewHolder(parent)

}