package dev.olshevski.paging3sandbox

import android.util.Log
import androidx.paging.PagingSource
import kotlinx.coroutines.delay

class ItemPagingSource(private val pageSize: Int) : PagingSource<Int, Item>() {

    override suspend fun load(params: LoadParams<Int>): LoadResult<Int, Item> {
        Log.v("ItemPagingSource", "load key=${params.key} params=$params")
        require(pageSize == params.loadSize) // require all loads to be of fixed size
        val currentPage = params.key ?: 1;

        delay(3000) // emulate network delays

        return LoadResult.Page(
            data = generateItems(currentPage, pageSize),
            prevKey = if (currentPage == 1) null else currentPage - 1,
            nextKey = currentPage + 1
        ).also {
            Log.v("ItemPagingSource", "loadResult=$it")
        }
    }

    private fun generateItems(page: Int, perPage: Int) = Array(perPage) {
        val id = (page - 1) * perPage + it
        Item(id, "item $id")
    }.toList()

}