package dev.olshevski.paging3sandbox

import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import androidx.recyclerview.widget.RecyclerView
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach

class MainActivity : AppCompatActivity() {

    private val viewModel by viewModels<MainViewModel>()

    private val list by lazy { findViewById<RecyclerView>(R.id.list) }

    private val itemPagingAdapter = ItemPagingAdapter()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        list.adapter = itemPagingAdapter

        lifecycleScope.launchWhenStarted {
            viewModel.pagingDataFlow.onEach {
                itemPagingAdapter.submitData(it)
            }.launchIn(this)
        }
    }

}