package dev.olshevski.paging3sandbox

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import androidx.paging.Pager
import androidx.paging.PagingConfig
import androidx.paging.cachedIn

class MainViewModel : ViewModel() {

    private companion object {
        const val PAGE_SIZE = 10
    }

    val pagingDataFlow = Pager(
        PagingConfig(
            pageSize = PAGE_SIZE,
            initialLoadSize = PAGE_SIZE,
            enablePlaceholders = false,
            maxSize = 5 * PAGE_SIZE // 5 pages top
        )
    ) {
        ItemPagingSource(PAGE_SIZE)
    }.flow.cachedIn(viewModelScope)

}