package v2sdk.sample;

import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.util.Log;

import java.util.concurrent.TimeUnit;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.schedulers.Schedulers;

import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.iot.IotClient;

public class MainActivity extends AppCompatActivity {
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Completable.fromAction(this::tryIt)
            .observeOn(Schedulers.io())
            .subscribeOn(Schedulers.io())
            .timeout(5, TimeUnit.SECONDS)
            .blockingAwait();
    }

    private void tryIt() {
        String accessKey = "I";
        String secretKey = "Removed";
        String sessionToken = "Them";
        AwsSessionCredentials credentials = AwsSessionCredentials.create(accessKey, secretKey, sessionToken);
        IotClient iot = IotClient.builder()
            .region(Region.US_EAST_1)
            .credentialsProvider(StaticCredentialsProvider.create(credentials))
            .httpClient(UrlConnectionHttpClient.create())
            .build();

        Log.d("MainActivity", "authorizers = " + iot.listAuthorizers().authorizers());
    }
}
