package com.example.recyclerviewdemo;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.selection.ItemDetailsLookup;
import androidx.recyclerview.selection.SelectionPredicates;
import androidx.recyclerview.selection.SelectionTracker;
import androidx.recyclerview.selection.StableIdKeyProvider;
import androidx.recyclerview.selection.StorageStrategy;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity
{
	private static final int LIST_SIZE = 20;
	private MyAdapter adapter;
	private RecyclerView recyclerView;
	private SelectionTracker<Long> selectionTracker;

	@Override
	protected void onCreate(Bundle savedInstanceState)
	{
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		adapter = new MyAdapter();
		recyclerView = findViewById(R.id.recyclerView);
		recyclerView.setAdapter(adapter);
		recyclerView.setLayoutManager(new LinearLayoutManager(this));
		selectionTracker = new SelectionTracker.Builder<Long>(
				"my-selection",
				recyclerView,
				new StableIdKeyProvider(recyclerView),
				new ChecklistItemDetailsLookup(),
				StorageStrategy.createLongStorage()
		).withSelectionPredicate(SelectionPredicates.<Long>createSelectAnything()).build();
		selectionTracker.addObserver(new SelectionTracker.SelectionObserver()
		{
			@Override
			public void onItemStateChanged(@NonNull Object key, boolean selected)
			{
				super.onItemStateChanged(key, selected);
				Log.e("onItemStateChanged", key + ": " + selected);
				StringBuilder sb = new StringBuilder();
			}
		});
	}

	class MyAdapter extends RecyclerView.Adapter<MyViewHolder>
	{
		private String[] items;

		public MyAdapter()
		{
			setHasStableIds(true);
			items = new String[20];
			for (int i = 0; i < LIST_SIZE; ++i)
				items[i] = "Item " + i;
		}

		@NonNull
		@Override
		public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType)
		{
			final MyViewHolder mvh = new MyViewHolder(LayoutInflater.from(parent.getContext()).inflate(R.layout.list_item, parent, false));
			mvh.itemView.setOnClickListener(new View.OnClickListener()
			{
				@Override
				public void onClick(View v)
				{
					Log.e("onClick", "item " + recyclerView.getChildItemId(v));
					new AlertDialog.Builder(MainActivity.this).setMessage("" + adapter.items[recyclerView.getChildAdapterPosition(v)]).show();
				}
			});
			return mvh;
		}

		@Override
		public void onBindViewHolder(@NonNull MyViewHolder holder, int position)
		{
			holder.titleTextView.setText(items[position]);
			holder.itemView.setActivated(selectionTracker.isSelected((long)position));
		}

		@Override
		public long getItemId(int position)
		{
			return position;
		}

		@Override
		public int getItemCount()
		{
			return items.length;
		}
	}

	class MyViewHolder extends RecyclerView.ViewHolder
	{
		public TextView titleTextView;
		public TextView dragTextView;

		public MyViewHolder(View itemView)
		{
			super(itemView);
			titleTextView = itemView.findViewById(R.id.titleTextView);
			dragTextView = itemView.findViewById(R.id.dragTextView);
		}
	}

	class ChecklistItemDetailsLookup extends ItemDetailsLookup<Long>
	{
		@Nullable
		@Override
		public ItemDetails<Long> getItemDetails(@NonNull MotionEvent e)
		{
			View view = recyclerView.findChildViewUnder(e.getX(), e.getY());
			if (view != null)
			{
				final int pos = recyclerView.getChildAdapterPosition(view);
				return new ItemDetailsLookup.ItemDetails<Long>()
				{
					@Override
					public int getPosition()
					{
						return pos;
					}

					@Nullable
					@Override
					public Long getSelectionKey()
					{
						return (long)pos;
					}
				};
			}
			return null;
		}
	}
}