package com.example.conditionalnav.ui

import android.os.Bundle
import android.view.View
import android.widget.Button
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.SavedStateHandle
import androidx.lifecycle.observe
import androidx.navigation.fragment.findNavController
import com.example.conditionalnav.R

class LoginFragment : Fragment(R.layout.login_fragment) {
    companion object {
        const val LOGIN_SUCCESSFUL: String = "LOGIN_SUCCESSFUL"
    }

    private val userViewModel by activityViewModels<UserViewModel>()
    private lateinit var savedStateHandle: SavedStateHandle

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        view.findViewById<Button>(R.id.button_succeed)?.setOnClickListener(this::onClickButtonSucceed)
        view.findViewById<Button>(R.id.button_fail)?.setOnClickListener(this::onClickButtonFail)
        savedStateHandle = findNavController().previousBackStackEntry!!.savedStateHandle
        savedStateHandle.set(LOGIN_SUCCESSFUL, false)
    }

    private fun onClickButtonSucceed(view: View) {
        userViewModel.login(true).observe(viewLifecycleOwner) {
            savedStateHandle.set(LOGIN_SUCCESSFUL, true)
            findNavController().popBackStack()
        }
    }

    private fun onClickButtonFail(view: View) {
        userViewModel.login(false).observe(viewLifecycleOwner) {
            findNavController().popBackStack()
        }
    }
}
