package com.example.conditionalnav.ui

import android.os.Bundle
import android.view.View
import android.widget.Button
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.observe
import androidx.navigation.fragment.findNavController
import com.example.conditionalnav.R

class MainFragment : Fragment(R.layout.main_fragment) {
    private val userViewModel by activityViewModels<UserViewModel>()

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        view.findViewById<Button>(R.id.button_profile)
            ?.setOnClickListener(this::onClickButtonProfile)
        val buttonLogout = view.findViewById<Button>(R.id.button_logout)?.apply {
            setOnClickListener(this@MainFragment::onClickButtonLogout)
        }

        userViewModel.user.observe(viewLifecycleOwner) { user ->
            val visibility = if (user != null) View.VISIBLE else View.GONE
            buttonLogout?.visibility = visibility
        }
    }

    private fun onClickButtonProfile(view: View) {
        findNavController().navigate(R.id.action_mainFragment_to_profileFragment)
    }

    private fun onClickButtonLogout(view: View) {
        userViewModel.logout()
    }
}
