package com.example.conditionalnav.ui

import android.os.Bundle
import android.view.View
import android.widget.TextView
import androidx.fragment.app.Fragment
import androidx.fragment.app.activityViewModels
import androidx.lifecycle.observe
import androidx.navigation.NavOptions
import androidx.navigation.fragment.findNavController
import com.example.conditionalnav.R

class ProfileFragment : Fragment(R.layout.profile_fragment) {
    private val userViewModel by activityViewModels<UserViewModel>()

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        val welcomeTextView = view.findViewById<TextView>(R.id.welcome)
        val navController = findNavController()
        userViewModel.user.observe(viewLifecycleOwner) { user ->
            if (user != null) {
                welcomeTextView.text = getString(R.string.welcome_format, user.username)
            } else {
                navController.navigate(R.id.loginFragment)
            }
        }
        // This should only fire after the user returns to this fragment
        navController.currentBackStackEntry!!.savedStateHandle.getLiveData<Boolean>(
                LoginFragment.LOGIN_SUCCESSFUL).observe(viewLifecycleOwner) {
                    if (!it) {
                        val startDestinationId = navController.graph.startDestination
                        val navOptions =
                                NavOptions.Builder().setPopUpTo(startDestinationId, true).build()
                        navController.navigate(startDestinationId, null, navOptions)
                    }
                }
    }
}
