package com.example.conditionalnav.ui

import androidx.lifecycle.LiveData
import androidx.lifecycle.MediatorLiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel

class UserViewModel : ViewModel() {
    data class User(val username: String)

    val user = MutableLiveData<User?>(null)

    fun login(shouldSucceed: Boolean): LiveData<Boolean> {
        if (shouldSucceed) {
            user.value = User("username")
        }
        return MutableLiveData(shouldSucceed)
    }

    fun logout() {
        user.value = null
    }
}
