import com.android.build.gradle.api.BaseVariant
import com.android.build.gradle.internal.dsl.NdkOptions

plugins {
    id("com.android.application")
    id("kotlin-android")
    id("kotlin-android-extensions")
}

val appAbiFilters = arrayOf("arm64-v8a", "armeabi-v7a", "x86", "x86_64")

androidExtensions {
    features = setOf("parcelize")
}

tasks.whenTaskAdded(object : Action<Task> {
    override fun execute(task: Task) {
        if (task.name.contains("crashlytics", true)
            && task.name.contains("upload", true)
        ) {
            task.enabled = false
        }
    }
})

android {
    compileSdkVersion(30)

    defaultConfig {
        applicationId = "dev.niltsiar.myapplication"
        minSdkVersion(21)
        targetSdkVersion(30)
        versionCode = 1
        versionName = "1.0"

        testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"

        resConfigs("en", "es")

        lintOptions {
            isAbortOnError = false
        }

        ndk(object : Action<NdkOptions> {
            override fun execute(options: NdkOptions) {
                options.abiFilters(*appAbiFilters)
            }
        })
    }

    buildTypes {
        getByName("release") {
            isMinifyEnabled = false
            proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
        }
    }
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_1_8
        targetCompatibility = JavaVersion.VERSION_1_8
    }
    kotlinOptions {
        jvmTarget = "1.8"
    }
    buildFeatures {
        viewBinding = true
    }
    applicationVariants.all {
        resValue("string", "app_name", "My App Name")
        buildConfigField("CUSTOM_VERSION_NAME", "0.0.1-custom")
    }
    splits {
        abi {
            isEnable = true
            reset()
            include(*appAbiFilters)
            isUniversalApk = true
        }
    }
}

dependencies {
    coreLibraryDesugaring(Libs.coreDesugarLibrary)
    implementation(Libs.kotlinStdlib)
    implementation(Libs.coreKtx)
    implementation(Libs.appCompat)
    implementation(Libs.material)
    implementation(Libs.constraintLayout)

}

fun BaseVariant.buildConfigField(name: String, value: String) = buildConfigField("String", name, "\"$value\"")
