import org.gradle.api.JavaVersion

object Plugins {
    const val android = "com.android.application"
    const val androidLibrary = "com.android.library"
    const val javaLibrary = "java-library"
    const val kotlinAndroid = "kotlin-android"
    const val kotlinAndroidExtensions = "kotlin-android-extensions"
    const val kotlin = "kotlin"
    const val kapt = "kotlin-kapt"
    const val gradleVersions = "com.github.ben-manes.versions"
    const val navigationKotlin = "androidx.navigation.safeargs.kotlin"
    const val googleServices = "com.google.gms.google-services"
    const val spotless = "com.diffplug.spotless"
    const val gradleGit = "org.ajoberstar.grgit"
    const val detekt = "io.gitlab.arturbosch.detekt"
    const val firebaseCrashlytics = "com.google.firebase.crashlytics"
    const val firebasePerformance = "com.google.firebase.firebase-perf"
}

object Versions {
    const val coreDesugarLibrary = "1.0.9"
    const val kotlin = "1.3.72"
    const val coroutines = "1.3.8"
    const val androidGradlePlugin = "4.1.0-beta04"
    const val gradleVersions = "0.29.0"
    const val googleServices = "4.3.3"
    const val spotless = "5.1.0"
    const val ktlint = "0.37.2"
    const val gradleGit = "4.0.2"
    const val detekt = "1.10.0"
    const val firebaseCrashlyticsPlugin = "2.2.0"
    const val firebasePerformancePlugin = "1.3.1"

    const val minSdk = 23
    const val targetSdk = 29

    val sourceCompatibility = JavaVersion.VERSION_1_8
    val targetCompatibility = JavaVersion.VERSION_1_8

    const val appCompat = "1.2.0-rc01"
    const val coreKtx = "1.3.0"
    const val fragment = "1.2.5"
    const val legacySupport = "1.0.0"
    const val material = "1.2.0-rc01"
    const val constraintLayout = "2.0.0-beta8"
    const val lifecycle = "2.2.0"
    const val room = "2.2.5"
    const val navigation = "2.3.0"
    const val drawerLayout = "1.1.0"
    const val securityCrypto = "1.0.0-rc02"
    const val viewpager2 = "1.0.0"
    const val androidxSqlite = "2.1.0"
    const val workmanager = "2.4.0-rc01"

    const val playServicesBase = "17.3.0"
    const val firebaseAnalytics = "17.4.4"
    const val firebaseCrashlytics = "17.1.1"
    const val firebasePerformance = "19.0.8"

    const val arrow = "0.10.5"
    const val timber = "4.7.1"
    const val moshi = "1.9.3"
    const val retrofit = "2.9.0"
    const val okhttp = "4.8.0"
    const val shimo = "0.1.0"

    const val argon = "13.1"
    const val sqlcipher = "4.4.0"

    const val awesomeQrCode = "1.2.0"
    const val zxing = "3.4.0"
    const val markwon = "4.4.0"
    const val flowBinding = "0.12.0"
    const val viewpagerDotsIndicator = "1.0.4"
    const val coil = "0.11.0"

    const val junit4 = "4.13"
    const val junit5 = "5.6.2"
    const val mockk = "1.10.0"
    const val kotest = "4.0.2"

    const val chucker = "3.2.0"
    const val oklog = "2.3.0"
    const val leakCanary = "2.4"
    const val debugDb = "1.0.6"

    const val koin = "2.1.6"
    const val uniflow = "0.11.2"

    const val calendar = "3.1.0"

    const val gandalf = "1.4.0"

    const val fluidSlider = "0.3.1"

    const val bugfender = "3.0.5"
}

object BuildTools {
    const val androidGradlePlugin = "com.android.tools.build:gradle:${Versions.androidGradlePlugin}"
    const val kotlinGradlePlugin = "org.jetbrains.kotlin:kotlin-gradle-plugin:${Versions.kotlin}"
    const val gradleVersions = "com.github.ben-manes:gradle-versions-plugin:${Versions.gradleVersions}"
    const val navigationSafeArgs = "androidx.navigation:navigation-safe-args-gradle-plugin:${Versions.navigation}"
    const val googleServices = "com.google.gms:google-services:${Versions.googleServices}"
    const val spotless = "com.diffplug.spotless:spotless-plugin-gradle:${Versions.spotless}"
    const val gradleGit = "org.ajoberstar:gradle-git:${Versions.gradleGit}"
    const val firebaseCrashlytics = "com.google.firebase:firebase-crashlytics-gradle:${Versions.firebaseCrashlyticsPlugin}"
    const val firebasePerformance = "com.google.firebase:perf-plugin:${Versions.firebasePerformancePlugin}"
}

object Libs {
    const val coreDesugarLibrary = "com.android.tools:desugar_jdk_libs:${Versions.coreDesugarLibrary}"
    const val kotlinStdlib = "org.jetbrains.kotlin:kotlin-stdlib-jdk7:${Versions.kotlin}"
    const val coroutines = "org.jetbrains.kotlinx:kotlinx-coroutines-core:${Versions.coroutines}"
    const val coroutinesAndroid = "org.jetbrains.kotlinx:kotlinx-coroutines-android:${Versions.coroutines}"
    const val appCompat = "androidx.appcompat:appcompat:${Versions.appCompat}"
    const val coreKtx = "androidx.core:core-ktx:${Versions.coreKtx}"
    const val fragmentKtx = "androidx.fragment:fragment-ktx:${Versions.fragment}"
    const val legacySupport = "androidx.legacy:legacy-support-v4:${Versions.legacySupport}"
    const val material = "com.google.android.material:material:${Versions.material}"
    const val constraintLayout = "androidx.constraintlayout:constraintlayout:${Versions.constraintLayout}"
    const val lifecycle = "androidx.lifecycle:lifecycle-extensions:${Versions.lifecycle}"
    const val lifecycleCommonJava8 = "androidx.lifecycle:lifecycle-common-java8:${Versions.lifecycle}"
    const val roomKtx = "androidx.room:room-ktx:${Versions.room}"
    const val liveDataKtx = "androidx.lifecycle:lifecycle-livedata-ktx:${Versions.lifecycle}"
    const val viewModelKtx = "androidx.lifecycle:lifecycle-viewmodel-ktx:${Versions.lifecycle}"
    const val navigationFragmentKtx = "androidx.navigation:navigation-fragment-ktx:${Versions.navigation}"
    const val navigationUiKtx = "androidx.navigation:navigation-ui-ktx:${Versions.navigation}"
    const val drawerLayout = "androidx.drawerlayout:drawerlayout:${Versions.drawerLayout}"
    const val securityCrypto = "androidx.security:security-crypto:${Versions.securityCrypto}"
    const val viewPager2 = "androidx.viewpager2:viewpager2:${Versions.viewpager2}"
    const val androidxSqlite = "androidx.sqlite:sqlite:${Versions.androidxSqlite}"
    const val workManagerKtx = "androidx.work:work-runtime-ktx:${Versions.workmanager}"

    const val playServicesBase = "com.google.android.gms:play-services-base:${Versions.playServicesBase}"
    const val firebaseAnalytics = "com.google.firebase:firebase-analytics-ktx:${Versions.firebaseAnalytics}"
    const val firebaseCrashlytics = "com.google.firebase:firebase-crashlytics:${Versions.firebaseCrashlytics}"
    const val firebasePerformance = "com.google.firebase:firebase-perf:${Versions.firebasePerformance}"

    const val arrowCore = "io.arrow-kt:arrow-core:${Versions.arrow}"
    const val arrowSyntax = "io.arrow-kt:arrow-syntax:${Versions.arrow}"
    const val timber = "com.jakewharton.timber:timber:${Versions.timber}"
    const val moshi = "com.squareup.moshi:moshi:${Versions.moshi}"
    const val retrofit = "com.squareup.retrofit2:retrofit:${Versions.retrofit}"
    const val retrofitMoshi = "com.squareup.retrofit2:converter-moshi:${Versions.retrofit}"
    const val okhttp = "com.squareup.okhttp3:okhttp:${Versions.okhttp}"
    const val plumberAndroid = "com.squareup.leakcanary:plumber-android:${Versions.leakCanary}"

    const val argon = "org.signal:argon2:${Versions.argon}"
    const val sqlcipher = "net.zetetic:android-database-sqlcipher:${Versions.sqlcipher}"

    const val awesomeQrCode = "com.github.SumiMakito:AwesomeQRCode:${Versions.awesomeQrCode}"
    const val zxing = "com.google.zxing:core:${Versions.zxing}"
    const val markwon = "io.noties.markwon:core:${Versions.markwon}"
    const val linkiFyMarkwon = "io.noties.markwon:linkify:${Versions.markwon}"
    const val viewpagerDotsIndicator = "com.github.zhpanvip:viewpagerindicator:${Versions.viewpagerDotsIndicator}"

    const val coil = "io.coil-kt:coil:${Versions.coil}"

    const val flowBindingAndroid = "io.github.reactivecircus.flowbinding:flowbinding-android:${Versions.flowBinding}"
    const val flowBindingActivity = "io.github.reactivecircus.flowbinding:flowbinding-activity:${Versions.flowBinding}"
    const val flowBindingAppCompat = "io.github.reactivecircus.flowbinding:flowbinding-appcompat:${Versions.flowBinding}"
    const val flowBindingCore = "io.github.reactivecircus.flowbinding:flowbinding-core:${Versions.flowBinding}"
    const val flowBindingDrawerLayout = "io.github.reactivecircus.flowbinding:flowbinding-drawerlayout:${Versions.flowBinding}"
    const val flowBindingLifecycle = "io.github.reactivecircus.flowbinding:flowbinding-lifecycle:${Versions.flowBinding}"
    const val flowBindingNavigation = "io.github.reactivecircus.flowbinding:flowbinding-navigation:${Versions.flowBinding}"
    const val flowBindingPreference = "io.github.reactivecircus.flowbinding:flowbinding-preference:${Versions.flowBinding}"
    const val flowBindingRecyclerView = "io.github.reactivecircus.flowbinding:flowbinding-recyclerview:${Versions.flowBinding}"
    const val flowBindingSwipeRefreshLayout = "io.github.reactivecircus.flowbinding:flowbinding-swiperefreshlayout:${Versions.flowBinding}"
    const val flowBindingViewpager = "io.github.reactivecircus.flowbinding:flowbinding-viewpager:${Versions.flowBinding}"
    const val flowBindingViewpager2 = "io.github.reactivecircus.flowbinding:flowbinding-viewpager2:${Versions.flowBinding}"
    const val flowBindingMaterial = "io.github.reactivecircus.flowbinding:flowbinding-material:${Versions.flowBinding}"

    const val koin = "org.koin:koin-core:${Versions.koin}"
    const val koinAndroid = "org.koin:koin-android:${Versions.koin}"
    const val koinAndroidScope = "org.koin:koin-androidx-scope:${Versions.koin}"
    const val koinAndroidViewModel = "org.koin:koin-androidx-viewmodel:${Versions.koin}"
    const val koinAndroidFragment = "org.koin:koin-androidx-fragment:${Versions.koin}"

    const val uniflowCore = "io.uniflow:uniflow-core:${Versions.uniflow}"
    const val uniflowTest = "io.uniflow:uniflow-test:${Versions.uniflow}"
    const val uniflowAndroidX = "io.uniflow:uniflow-androidx:${Versions.uniflow}"
    const val uniflowAndroidXTest = "io.uniflow:uniflow-androidx-test:${Versions.uniflow}"

    const val calendar = "dev.niltsiar:CompactCalendarView:${Versions.calendar}"

    const val gandalf = "com.btkelly:gandalf:${Versions.gandalf}"

    const val fluidSlider = "com.ramotion.fluidslider:fluid-slider:${Versions.fluidSlider}"
}

object Kapt {
    const val lifecycle = "androidx.lifecycle:lifecycle-compiler:${Versions.lifecycle}"
    const val room = "androidx.room:room-compiler:${Versions.room}"
    const val moshiCodegen = "com.squareup.moshi:moshi-kotlin-codegen:${Versions.moshi}"
    const val arrowMeta = "io.arrow-kt:arrow-meta:${Versions.arrow}"
}

object Tests {
    const val junit = "junit:junit:${Versions.junit4}"
    const val mockk = "io.mockk:mockk:${Versions.mockk}"
    const val mockwebserver = "com.squareup.okhttp3:mockwebserver:${Versions.okhttp}"
    const val coroutinesTest = "org.jetbrains.kotlinx:kotlinx-coroutines-test:${Versions.coroutines}"
    const val kotestRunner = "io.kotest:kotest-runner-junit5-jvm:${Versions.kotest}"
    const val kotestAssertionsCore = "io.kotest:kotest-assertions-core-jvm:${Versions.kotest}"
    const val kotestProperty = "io.kotest:kotest-property-jvm:${Versions.kotest}"
    const val junitJupiterApi = "org.junit.jupiter:junit-jupiter-api:${Versions.junit5}"
    const val junitJupiterEngine = "org.junit.jupiter:junit-jupiter-engine:${Versions.junit5}"
}

object DebugLibs {
    const val chucker = "com.github.ChuckerTeam.Chucker:library:${Versions.chucker}"
    const val oklog = "com.github.simonpercic:oklog3:${Versions.oklog}"
    const val okhttpLogginInterceptor = "com.squareup.okhttp3:logging-interceptor:${Versions.okhttp}"
    const val leakcanary = "com.squareup.leakcanary:leakcanary-android:${Versions.leakCanary}"
    const val debugDb = "com.amitshekhar.android:debug-db:${Versions.debugDb}"
    const val shimo = "com.jakewharton.moshi:shimo:${Versions.shimo}"
    const val bugfender = "com.bugfender.sdk:android:${Versions.bugfender}"
}
