import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale
import java.util.TimeZone

fun getBuildTime() = Date().format("yyyy-MM-dd'T'HH:mm'Z'", TimeZone.getTimeZone("UTC"))

private fun Date.format(format: String, tz: TimeZone): String {
    val sdf = SimpleDateFormat(format, Locale.ROOT).apply {
        timeZone = tz
    }
    return sdf.format(this)
}
