package com.android.example.paging.pagingwithnetwork.reddit.ui

import android.os.Bundle
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.viewpager2.adapter.FragmentStateAdapter
import com.android.example.paging.pagingwithnetwork.R
import com.google.android.material.tabs.TabLayoutMediator
import kotlinx.android.synthetic.main.fragment_view_pager.*

class ViewPagerFragment : Fragment() {
    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?,
                              savedInstanceState: Bundle?): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_view_pager, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        pager.adapter = RedditPagerAdapter(this, listOf(FirstPageFragment("androiddev"), FirstPageFragment("Kotlin")))
        pager.offscreenPageLimit = 2
        TabLayoutMediator(tab_layout, pager){tab, position ->
            tab.text = "Page $position"
        }.attach()
    }
}

class RedditPagerAdapter(
        parentFragment: Fragment,
        private val fragments: List<Fragment>
): FragmentStateAdapter(parentFragment) {

    override fun getItemCount(): Int = fragments.size

    override fun createFragment(position: Int): Fragment = fragments[position]
}