package com.example.statecodelab.todo

import android.os.Bundle
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.compose.ui.platform.setContent
import com.example.statecodelab.ui.StateCodelabTheme

class TodoActivity : AppCompatActivity() {

    val todoViewModel by viewModels<TodoViewModel>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            StateCodelabTheme {
                TodoScreen(
                    todoViewModel.todoItems,
                    todoViewModel.currentEditItem,
                    todoViewModel::addItem,
                    todoViewModel::removeItem,
                    todoViewModel::onEditItemSelected,
                    todoViewModel::onEditItemChange,
                    todoViewModel::onEditDone
                )
            }
        }
    }
}