package com.example.fragmentanimationbug

import android.os.Bundle
import android.view.View
import android.widget.Button
import androidx.fragment.app.Fragment
import androidx.fragment.app.commit

class FragmentA : Fragment(R.layout.fragment_a) {
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        view.findViewById<Button>(R.id.button).setOnClickListener {
            parentFragmentManager.commit {
                setCustomAnimations(R.anim.activity_open_enter, R.anim.activity_open_exit,
                    R.anim.activity_close_enter, R.anim.activity_close_exit)

                replace(id, FragmentB.newInstance())
                addToBackStack(null)
            }
        }
    }

    companion object {
        fun newInstance() = FragmentA()
    }
}