package com.sample.r8

import android.os.Handler
import android.os.Looper
import android.util.Log
import java.lang.ref.WeakReference
import kotlin.concurrent.thread

private const val TAG = "ConfigurationManager"
typealias ConfigurationHandler = () -> Unit

class ConfigurationManager {
    private val handlers = mutableListOf<WeakReference<ConfigurationHandler>>()

    fun execute(handler: ConfigurationHandler) {
        handlers.add(WeakReference(handler))
        simulateNetworkCall()
    }

    private fun simulateNetworkCall() {
        thread {
            // this hack should trigger GC
            repeat(10_000) {
                val list = ArrayList<Int>()
                list.add(it)
                println(list)
            }
            Thread.sleep(1000)

            handlers.forEach {
                val currentHandler = it.get()
                if (currentHandler == null) {
                    Log.e(TAG, "Reference has been cleared")
                } else {
                    Handler(Looper.getMainLooper())
                        .post { currentHandler() }
                    Log.d(TAG, "Reference is present")
                }
            }
        }
    }
}