package com.sample.r8

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.widget.Toast

class MainActivity : AppCompatActivity() {

    private val configurationManager = ConfigurationManager()
    private var configurationHandler: ConfigurationHandler? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        configurationHandler = InternalHandler()
                .also(configurationManager::execute)
    }

    private inner class InternalHandler() : ConfigurationHandler {

        override fun invoke() {
            Toast.makeText(this@MainActivity, "Handler invoked", Toast.LENGTH_LONG).show()
        }
    }
}