package org.example.myapplication

import android.os.Bundle
import android.os.Handler
import android.view.View
import androidx.core.os.postDelayed
import androidx.fragment.app.Fragment
import androidx.transition.ChangeBounds
import androidx.transition.Transition
import androidx.transition.TransitionValues

class MainFragment : Fragment(R.layout.fragment_main) {
    init {
        sharedElementEnterTransition = ChangeBounds().setDuration(1000)
        enterTransition = NoOpTransition
        exitTransition = NoOpTransition
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        view.findViewById<View>(R.id.box).setOnClickListener {
            parentFragmentManager.beginTransaction()
                .setReorderingAllowed(true) // TODO: If you change this to false the transition works as expected
                .detach(this)
                .add(R.id.container, SecondFragment())
                .addToBackStack(null)
                .addSharedElement(it, "box")
                .commit()

            Handler().postDelayed(500) {
                parentFragmentManager.popBackStack()
            }
        }
    }
}

object NoOpTransition : Transition() {
    override fun captureStartValues(transitionValues: TransitionValues) {
    }

    override fun captureEndValues(transitionValues: TransitionValues) {
    }
}