package az.sample.fingerprintchecher

import android.os.Build
import android.os.Bundle
import android.util.Log
import androidx.annotation.RequiresApi
import androidx.appcompat.app.AppCompatActivity
import androidx.biometric.BiometricManager
import androidx.biometric.BiometricManager.Authenticators
import androidx.biometric.BiometricPrompt
import androidx.biometric.FingerprintDialogFragment
import androidx.core.content.ContextCompat
import kotlinx.android.synthetic.main.activity_main.*
import java.lang.Exception

class PasscodeActivity : AppCompatActivity(), CipherUtils.CipherListener {

    private val biometricPrompt: BiometricPrompt by lazy {
        BiometricPrompt(this, ContextCompat.getMainExecutor(this), authenticationCallback)
    }
    private val biometricManager: BiometricManager by lazy {
        BiometricManager.from(this)
    }

    private lateinit var cryptoObject: BiometricPrompt.CryptoObject

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)


        testBtn.setOnClickListener {
            if (biometricManager.canAuthenticate(Authenticators.BIOMETRIC_STRONG) == BiometricManager.BIOMETRIC_SUCCESS) {
                biometricPrompt.authenticate(getPromptInfo(), cryptoObject)
            }
        }

    }

    override fun onResume() {
        super.onResume()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            CipherUtils.init(this)
        }
    }


    override fun onPause() {
        super.onPause()
        biometricPrompt.cancelAuthentication()
    }


    private val authenticationCallback = object : BiometricPrompt.AuthenticationCallback() {
        override fun onAuthenticationError(errorCode: Int, errString: CharSequence) {
            super.onAuthenticationError(errorCode, errString)
            Log.d("AAAAA", "$errorCode :: $errString")
        }

        override fun onAuthenticationFailed() {
            super.onAuthenticationFailed()
            Log.d("AAAAA", "Authentication failed for an unknown reason")
        }

        override fun onAuthenticationSucceeded(result: BiometricPrompt.AuthenticationResult) {
            super.onAuthenticationSucceeded(result)
            Log.d("AAAAAA ", "onSuccess")
        }
    }



    private fun getPromptInfo(): BiometricPrompt.PromptInfo {
        return BiometricPrompt.PromptInfo.Builder()
            .setTitle("My App's Authentication")
            .setNegativeButtonText("Cancel")
            .setDescription("My App is using Android biometric authentication")
            .build()
    }



    override fun onCipherInitSuccessfully(cryptoObject: BiometricPrompt.CryptoObject) {
        this.cryptoObject = cryptoObject
    }


    @RequiresApi(Build.VERSION_CODES.M)
    override fun onCipherInitFail(e: Exception) {

    }

}
