package com.example.composetaps

import android.view.ViewGroup
import androidx.compose.foundation.Box
import androidx.compose.foundation.Text
import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.material.MaterialTheme
import androidx.compose.material.ripple.RippleIndication
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.platform.ComposeView
import androidx.compose.ui.unit.dp
import androidx.recyclerview.widget.RecyclerView

class ComposeViewHolder(parent: ViewGroup) : RecyclerView.ViewHolder(
    ComposeView(parent.context)
) {

    init {
        (itemView as ComposeView).setContent {
            Box(
                modifier = Modifier
                    .clickable(onClick = {}, indication = RippleIndication())
                    .fillMaxWidth()
                    .height(48.dp)
                    .padding(horizontal = 16.dp),
                gravity = Alignment.CenterStart,
            ) {
                Text(
                    text = "Compose Item View",
                    color = Color.Black,
                    style = MaterialTheme.typography.body1,
                )
            }
        }
    }
}