package com.example.composetaps

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.view.ViewGroup
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

class MainActivity : AppCompatActivity() {

    private val recyclerView by lazy(LazyThreadSafetyMode.NONE) {
        RecyclerView(this).apply {
            layoutManager = LinearLayoutManager(this@MainActivity)
            adapter = object : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

                override fun onCreateViewHolder(parent: ViewGroup, viewType: Int) =
                        when (viewType) {
                            0 -> AndroidViewHolder(parent)
                            1 -> ComposeViewHolder(parent)
                            else -> error("Invalid view type: $viewType")
                        }

                override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) = Unit

                override fun getItemViewType(position: Int) = position % 2

                override fun getItemCount() = 50

            }
        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(recyclerView)
    }

}