package com.example.navtestapp

import android.os.Bundle
import androidx.navigation.NavArgs
import java.lang.IllegalArgumentException
import kotlin.String
import kotlin.jvm.JvmStatic

data class MyFragmentArgs(
  val argumentFragment: String?
) : NavArgs {
  fun toBundle(): Bundle {
    val result = Bundle()
    result.putString("argument_fragment", this.argumentFragment)
    return result
  }

  companion object {
    @JvmStatic
    fun fromBundle(bundle: Bundle): MyFragmentArgs {
      bundle.setClassLoader(MyFragmentArgs::class.java.classLoader)
      val __argumentFragment : String?
      if (bundle.containsKey("argument_fragment")) {
        __argumentFragment = bundle.getString("argument_fragment")
      } else {
        throw IllegalArgumentException("Required argument \"argument_fragment\" is missing and does not have an android:defaultValue")
      }
      return MyFragmentArgs(__argumentFragment)
    }
  }
}
