package com.mercari.myapplication

import android.os.Bundle
import androidx.navigation.NavArgs
import java.lang.IllegalArgumentException
import kotlin.String
import kotlin.jvm.JvmStatic

data class NestedGraphArgs(
  val thisArgCantBeReferencedByAndroidStudio: String?
) : NavArgs {
  fun toBundle(): Bundle {
    val result = Bundle()
    result.putString("thisArgCantBeReferencedByAndroidStudio",
        this.thisArgCantBeReferencedByAndroidStudio)
    return result
  }

  companion object {
    @JvmStatic
    fun fromBundle(bundle: Bundle): NestedGraphArgs {
      bundle.setClassLoader(NestedGraphArgs::class.java.classLoader)
      val __thisArgCantBeReferencedByAndroidStudio : String?
      if (bundle.containsKey("thisArgCantBeReferencedByAndroidStudio")) {
        __thisArgCantBeReferencedByAndroidStudio =
            bundle.getString("thisArgCantBeReferencedByAndroidStudio")
      } else {
        throw IllegalArgumentException("Required argument \"thisArgCantBeReferencedByAndroidStudio\" is missing and does not have an android:defaultValue")
      }
      return NestedGraphArgs(__thisArgCantBeReferencedByAndroidStudio)
    }
  }
}
