package com.example.navoncommit

import android.os.Bundle
import android.util.Log
import androidx.annotation.StringRes
import androidx.appcompat.app.AppCompatActivity
import androidx.compose.foundation.Text
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.padding
import androidx.compose.material.*
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Call
import androidx.compose.material.icons.filled.ThumbUp
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.onCommit
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.vector.VectorAsset
import androidx.compose.ui.platform.setContent
import androidx.compose.ui.res.stringResource
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import androidx.navigation.compose.*
import androidx.ui.tooling.preview.Preview
import com.example.navoncommit.ui.NavOnCommitTheme

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContent {
            NavOnCommitTheme {
                AppLayout()
            }
        }
    }
}

@Composable
fun AppLayout() {
    val navController = rememberNavController()
    val items = listOf(
        NavScreens.First,
        NavScreens.Second,
    )
    Scaffold(
        bottomBar = {
            BottomNavigation {
                val navBackStackEntry by navController.currentBackStackEntryAsState()
                val currentRoute = navBackStackEntry?.arguments?.getString(KEY_ROUTE)
                items.forEach { screen ->
                    BottomNavigationItem(
                        icon = { Icon(screen.icon) },
                        label = { Text(stringResource(screen.resourceId)) },
                        selected = currentRoute == screen.route,
                        onClick = {
                            navController.popBackStack(
                                navController.graph.startDestination,
                                currentRoute != NavScreens.First.route,
                            )
                            if (currentRoute != screen.route) {
                                navController.navigate(screen.route)
                            }
                        }
                    )
                }
            }
        }
    ) { innerPadding ->
        Box(modifier = Modifier.padding(innerPadding)) {
            NavHost(navController = navController, startDestination = NavScreens.First.route) {
                composable(NavScreens.First.route) { FirstScreen() }
                composable(NavScreens.Second.route) {
                    onCommit(it) {
                        Log.d("asdf","on commit, navBackStackEntry: $it")
                        it.lifecycle.addObserver(object: LifecycleEventObserver {
                            override fun onStateChanged(source: LifecycleOwner, event: Lifecycle.Event) {
                                Log.d("asdf","navBackstackEntry event: $event")
                            }
                        })
                    }
                    SecondScreen(onButtonClick = {
                        navController.navigate("ThirdScreen")
                    })
                }
                composable("ThirdScreen") { ThirdScreen() }
            }
        }
    }
}

@Composable
fun FirstScreen() {
    Text(text = "FirstScreen!")
}

@Composable
fun SecondScreen(onButtonClick: () -> Unit) {
    Column {
        Text(text = "SecondScreen!")
        Button(onClick = onButtonClick) {
            Text(text = "To third screen")
        }
    }
}

@Composable
fun ThirdScreen() {
    Text(text = "ThirdScreen!")
}

@Composable
fun Greeting(name: String) {
    Text(text = "Hello $name!")
}

@Preview(showBackground = true)
@Composable
fun DefaultPreview() {
    NavOnCommitTheme {
        Greeting("Android")
    }
}

sealed class NavScreens(val route: String, @StringRes val resourceId: Int, val icon: VectorAsset) {
    object First : NavScreens("firstScreen", R.string.first_screen, Icons.Filled.ThumbUp)
    object Second : NavScreens("secondScreen", R.string.second_screen, Icons.Filled.Call)
}