package com.example.viewpager2bug

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.TypedValue
import android.view.Gravity
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import kotlinx.android.synthetic.main.activity_main.*

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        view_pager.offscreenPageLimit = 1
        view_pager.adapter = SimpleAdapter(5)
    }

    private class SimpleAdapter constructor(
        private val itemCount: Int
    ): RecyclerView.Adapter<SimpleAdapter.SimpleViewHolder>() {

        class SimpleViewHolder(itemView: View): RecyclerView.ViewHolder(itemView) {
            val textView = itemView as TextView
        }

        override fun getItemCount() = itemCount

        override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): SimpleViewHolder {
            val textView = TextView(parent.context).apply {
                setTextSize(TypedValue.COMPLEX_UNIT_SP, 48f)
                gravity = Gravity.CENTER
                layoutParams = RecyclerView.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
            }

            return SimpleViewHolder(textView)
        }

        override fun onBindViewHolder(holder: SimpleViewHolder, position: Int) {
            holder.textView.text = position.toString()
        }
    }
}