package com.example.fragmentanimationbug

import android.os.Bundle
import android.view.View
import android.widget.Button
import androidx.fragment.app.Fragment
import androidx.fragment.app.commit

class FragmentA : Fragment(R.layout.fragment_a) {
    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        view.findViewById<Button>(R.id.button).setOnClickListener {
            parentFragmentManager.commit {
                setCustomAnimations(R.animator.fragment_open_enter, R.animator.fragment_open_exit,
                    R.animator.fragment_close_enter, R.animator.fragment_close_exit)

                replace(id, FragmentB.newInstance())
                addToBackStack(null)
            }
        }
    }

    companion object {
        fun newInstance() = FragmentA()
    }
}