package com.example.fragmentnoresume

import android.os.Bundle
import android.transition.ChangeBounds
import android.util.Log
import androidx.activity.viewModels
import androidx.appcompat.app.AppCompatActivity
import androidx.databinding.DataBindingUtil
import androidx.lifecycle.lifecycleScope
import com.example.fragmentnoresume.databinding.ActivityMainBinding
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach

class MainActivity : AppCompatActivity() {

    private lateinit var binding: ActivityMainBinding
    private val viewModel by viewModels<MainActivityViewModel>()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        binding = DataBindingUtil.setContentView(this, R.layout.activity_main)

        setSupportActionBar(binding.toolbar)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        supportActionBar?.setHomeActionContentDescription("Navigate back")

        // Option 1. Direct navigation - WORKS
        //showFirstScreen()

        // Option 2. Observing StateFlow from the Activity & navigating - WORKS
        /*viewModel.repositoryData.onEach {
            if (it is RepositoryState.FirstStep) {
                showFirstScreen()
            }
        }.launchIn(lifecycleScope)*/

        // Option 3. Observing LiveData from the Activity & navigation - DOESN'T WORK!
        viewModel.screen.observe(this, {
            if (it == MainActivityViewModel.Companion.Screen.FIRST_SCREEN) {
                showFirstScreen()
            }
        })
    }

    override fun onResume() {
        super.onResume()
        Log.i("DEBUG123", "MainActivity#onResume")
    }

    private fun showFirstScreen() {
        val fragment = FirstFragment().apply {
            enterTransition = ChangeBounds()
            exitTransition = ChangeBounds()
        }

        supportFragmentManager.beginTransaction()
                .add(R.id.fragment_container, fragment, fragment.javaClass.name)
                .commitAllowingStateLoss()
    }
}