package com.example.fragmentnoresume

import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.launchIn
import kotlinx.coroutines.flow.onEach

class MainActivityViewModel : ViewModel() {

    val repositoryData: StateFlow<RepositoryState> =
        MutableStateFlow(RepositoryState.FirstStep)

    private val _screen = MutableLiveData<Screen>()
    val screen: LiveData<Screen> = _screen

    init {
        repositoryData
            .onEach {
                _screen.value = Screen.FIRST_SCREEN
            }.launchIn(viewModelScope)
    }

    companion object {
        enum class Screen {
            FIRST_SCREEN
        }
    }
}

sealed class RepositoryState {
    object FirstStep : RepositoryState()
}