package com.lb.myapplication

import android.os.Bundle
import android.view.View
import androidx.activity.enableEdgeToEdge
import androidx.appcompat.app.AppCompatActivity
import androidx.core.view.ViewCompat
import androidx.core.view.WindowInsetsCompat
import kotlin.concurrent.thread

class MainActivity : AppCompatActivity() {
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        findViewById<View>(R.id.workerButton).setOnClickListener {
            UpdateWidgetWork.Companion.schedule(this@MainActivity)
        }
        findViewById<View>(R.id.backgroundThreadButton).setOnClickListener {
            thread {
                UpdateWidgetWork.Companion.doBackgroundWork(applicationContext)
            }
        }
    }
}
