package com.lb.myapplication

import android.content.Context
import android.os.Handler
import android.os.Looper
import androidx.annotation.UiThread
import androidx.annotation.WorkerThread
import androidx.work.OneTimeWorkRequest
import androidx.work.WorkManager
import androidx.work.Worker
import androidx.work.WorkerParameters

class UpdateWidgetWork(context: Context, private val parameters: WorkerParameters) : Worker(context, parameters) {
    override fun doWork(): Result {
        doBackgroundWork(applicationContext)
        return Result.success()
    }

    companion object {
        @WorkerThread
        fun doBackgroundWork(applicationContext: Context) {
            Handler(Looper.getMainLooper()).post {
                WidgetProvider.Companion.updateAppWidget(applicationContext)
            }
        }

        @UiThread
        fun schedule(context: Context) {
            val work = OneTimeWorkRequest.Builder(UpdateWidgetWork::class.java)
            WorkManager.getInstance(context).enqueue(work.build())
        }
    }
}
