package com.lb.myapplication

import android.appwidget.AppWidgetManager
import android.appwidget.AppWidgetProvider
import android.content.ComponentName
import android.content.Context
import android.preference.PreferenceManager
import android.util.Log
import android.widget.RemoteViews
import androidx.annotation.UiThread

class WidgetProvider : AppWidgetProvider() {
    override fun onUpdate(context: Context, appWidgetManager: AppWidgetManager, appWidgetIds: IntArray) {
        Log.d("AppLog", "WidgetProvider onUpdate")
        updateAppWidget(context, appWidgetIds)
    }

    companion object {
        @UiThread
        fun updateAppWidget(context: Context) {
            Log.d("AppLog", "updateAppWidget")
            val appWidgetManager = AppWidgetManager.getInstance(context)
            // Logger.log(LogLevel.DEBUG,"updating app widgets...");
            val cn = ComponentName(context, WidgetProvider::class.java)
            val appWidgetIds = appWidgetManager.getAppWidgetIds(cn)
            if (appWidgetIds?.isNotEmpty() == true)
                updateAppWidget(context, appWidgetIds)
            // Logger.log(LogLevel.DEBUG,"done");
        }

        @UiThread
        private fun updateAppWidget(context: Context, appWidgetIds: IntArray) {
            val appWidgetManager = AppWidgetManager.getInstance(context)
            val count = PreferenceManager.getDefaultSharedPreferences(context).getInt("count", 0)
            Log.d("AppLog", "updating widgets to show:$count")
            PreferenceManager.getDefaultSharedPreferences(context).edit().putInt("count", count + 1).apply()
            for (appWidgetId in appWidgetIds) {
                val rootRemoteViews = RemoteViews(context.packageName, R.layout.widget_layout)
                rootRemoteViews.setTextViewText(R.id.textView, count.toString())
                appWidgetManager.updateAppWidget(appWidgetId, rootRemoteViews)
            }
        }
    }
}
