package j2e.su.tictactoe

import android.os.Bundle
import android.transition.Slide
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.fragment.app.commit

class MainActivity : AppCompatActivity() {

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)

        // uncomment this to see temporary fix
        // FragmentManager.enableNewStateManager(false)

        if (savedInstanceState == null) {
            supportFragmentManager.commit {
                add(R.id.container, MyFragment())
            }
        }
    }

    fun hide(view: View) {
        val fragment = supportFragmentManager.findFragmentById(R.id.container)!!
        fragment.exitTransition = Slide()
        supportFragmentManager.commit {
            hide(fragment)
            addToBackStack(null)
        }
    }
}
