/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data;

import androidx.annotation.VisibleForTesting;
import com.google.samples.apps.iosched.model.Codelab;
import com.google.samples.apps.iosched.model.ConferenceData;
import com.google.samples.apps.iosched.model.ConferenceDay;
import com.google.samples.apps.iosched.model.Session;
import com.google.samples.apps.iosched.model.Speaker;
import com.google.samples.apps.iosched.shared.data.ConferenceDataRepository;
import com.google.samples.apps.iosched.shared.data.ConferenceDataSource;
import com.google.samples.apps.iosched.shared.data.UpdateSource;
import com.google.samples.apps.iosched.shared.data.db.AppDatabase;
import com.google.samples.apps.iosched.shared.data.db.CodelabFtsEntity;
import com.google.samples.apps.iosched.shared.data.db.SessionFtsEntity;
import com.google.samples.apps.iosched.shared.data.db.SpeakerFtsEntity;
import com.google.samples.apps.iosched.shared.util.TimeUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.BroadcastChannel;
import kotlinx.coroutines.channels.BroadcastChannelKt;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Singleton
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u00002\u00020\u0001B#\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\tH\u0002J\b\u0010#\u001a\u00020\tH\u0002J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0006\u0010'\u001a\u00020\tJ\u0010\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\tH\u0016J\u0006\u0010*\u001a\u00020!R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R.\u0010\u0018\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u00172\u000e\u0010\u0015\u001a\n\u0018\u00010\u0016j\u0004\u0018\u0001`\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/google/samples/apps/iosched/shared/data/ConferenceDataRepository;", "", "remoteDataSource", "Lcom/google/samples/apps/iosched/shared/data/ConferenceDataSource;", "boostrapDataSource", "appDatabase", "Lcom/google/samples/apps/iosched/shared/data/db/AppDatabase;", "(Lcom/google/samples/apps/iosched/shared/data/ConferenceDataSource;Lcom/google/samples/apps/iosched/shared/data/ConferenceDataSource;Lcom/google/samples/apps/iosched/shared/data/db/AppDatabase;)V", "conferenceDataCache", "Lcom/google/samples/apps/iosched/model/ConferenceData;", "currentConferenceDataVersion", "", "getCurrentConferenceDataVersion", "()I", "dataLastUpdatedChannel", "Lkotlinx/coroutines/channels/BroadcastChannel;", "", "dataLastUpdatedObservable", "Lkotlinx/coroutines/flow/Flow;", "getDataLastUpdatedObservable", "()Lkotlinx/coroutines/flow/Flow;", "<set-?>", "Ljava/lang/Exception;", "Lkotlin/Exception;", "latestException", "getLatestException", "()Ljava/lang/Exception;", "Lcom/google/samples/apps/iosched/shared/data/UpdateSource;", "latestUpdateSource", "getLatestUpdateSource", "()Lcom/google/samples/apps/iosched/shared/data/UpdateSource;", "loadConfDataLock", "closeDataLastUpdatedChannel", "", "getCacheOrBootstrapData", "getCacheOrBootstrapDataAndPopulateSearch", "getConferenceDays", "", "Lcom/google/samples/apps/iosched/model/ConferenceDay;", "getOfflineConferenceData", "populateSearchData", "conferenceData", "refreshCacheWithRemoteConferenceData", "shared_debug"})
public class ConferenceDataRepository {
    private ConferenceData conferenceDataCache;
    @Nullable
    private Exception latestException;
    @NotNull
    private UpdateSource latestUpdateSource;
    private final BroadcastChannel<Long> dataLastUpdatedChannel;
    @NotNull
    private final Flow<Long> dataLastUpdatedObservable;
    private final Object loadConfDataLock;
    private final ConferenceDataSource remoteDataSource;
    private final ConferenceDataSource boostrapDataSource;
    private final AppDatabase appDatabase;

    public final int getCurrentConferenceDataVersion() {
        ConferenceData conferenceData = this.conferenceDataCache;
        return conferenceData != null ? conferenceData.getVersion() : 0;
    }

    @Nullable
    public final Exception getLatestException() {
        return this.latestException;
    }

    @NotNull
    public final UpdateSource getLatestUpdateSource() {
        return this.latestUpdateSource;
    }

    @NotNull
    public final Flow<Long> getDataLastUpdatedObservable() {
        return this.dataLastUpdatedObservable;
    }

    @VisibleForTesting
    public final void closeDataLastUpdatedChannel() {
        SendChannel.DefaultImpls.close$default(this.dataLastUpdatedChannel, null, (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void refreshCacheWithRemoteConferenceData() {
        Object object;
        try {
            object = this.remoteDataSource.getRemoteConferenceData();
        }
        catch (IOException e) {
            this.latestException = e;
            throw (Throwable)e;
        }
        ConferenceData conferenceData = object;
        if (conferenceData == null) {
            Exception e;
            this.latestException = e = new Exception("Remote returned no conference data");
            throw (Throwable)e;
        }
        object = this.loadConfDataLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            this.conferenceDataCache = conferenceData;
            this.populateSearchData(conferenceData);
            Unit unit = Unit.INSTANCE;
        }
        this.latestException = null;
        this.dataLastUpdatedChannel.offer((Object)System.currentTimeMillis());
        this.latestUpdateSource = UpdateSource.NETWORK;
        this.latestException = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ConferenceData getOfflineConferenceData() {
        Object object = this.loadConfDataLock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            ConferenceData offlineData;
            boolean bl3 = false;
            ConferenceData conferenceData = this.conferenceDataCache;
            if (conferenceData == null) {
                conferenceData = this.getCacheOrBootstrapDataAndPopulateSearch();
            }
            this.conferenceDataCache = offlineData = conferenceData;
            ConferenceData conferenceData2 = offlineData;
            return conferenceData2;
        }
    }

    private final ConferenceData getCacheOrBootstrapDataAndPopulateSearch() {
        ConferenceData conferenceData = this.getCacheOrBootstrapData();
        this.populateSearchData(conferenceData);
        return conferenceData;
    }

    private final ConferenceData getCacheOrBootstrapData() {
        ConferenceData conferenceData = this.remoteDataSource.getOfflineConferenceData();
        if (conferenceData != null) {
            this.latestUpdateSource = UpdateSource.CACHE;
            return conferenceData;
        }
        ConferenceData conferenceData2 = this.boostrapDataSource.getOfflineConferenceData();
        if (conferenceData2 == null) {
            Intrinsics.throwNpe();
        }
        conferenceData = conferenceData2;
        this.latestUpdateSource = UpdateSource.BOOTSTRAP;
        return conferenceData;
    }

    /*
     * WARNING - void declaration
     */
    public void populateSearchData(@NotNull ConferenceData conferenceData) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Intrinsics.checkParameterIsNotNull((Object)conferenceData, (String)"conferenceData");
        Iterable $this$map$iv = conferenceData.getSessions();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void session2;
            Session session3 = (Session)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = new SessionFtsEntity(session2.getId(), session2.getTitle(), session2.getDescription(), CollectionsKt.joinToString$default((Iterable)session2.getSpeakers(), null, null, null, (int)0, null, (Function1)populateSearchData.sessionFtsEntities.1.1.INSTANCE, (int)31, null));
            collection.add(object);
        }
        List sessionFtsEntities2 = (List)destination$iv$iv;
        this.appDatabase.sessionFtsDao().insertAll(sessionFtsEntities2);
        Iterable $this$map$iv2 = conferenceData.getSpeakers();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Speaker bl = (Speaker)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            object = new SpeakerFtsEntity(it.getId(), it.getName(), it.getBiography());
            collection.add(object);
        }
        List speakers = (List)destination$iv$iv2;
        this.appDatabase.speakerFtsDao().insertAll(speakers);
        Iterable $this$map$iv3 = conferenceData.getCodelabs();
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Codelab bl2 = (Codelab)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl = false;
            object = new CodelabFtsEntity(it.getId(), it.getTitle(), it.getDescription());
            collection.add(object);
        }
        List codelabs = (List)destination$iv$iv3;
        this.appDatabase.codelabFtsDao().insertAll(codelabs);
    }

    @NotNull
    public List<ConferenceDay> getConferenceDays() {
        return TimeUtils.INSTANCE.getConferenceDays();
    }

    @Inject
    public ConferenceDataRepository(@Named(value="remoteConfDatasource") @NotNull ConferenceDataSource remoteDataSource, @Named(value="bootstrapConfDataSource") @NotNull ConferenceDataSource boostrapDataSource, @NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)remoteDataSource, (String)"remoteDataSource");
        Intrinsics.checkParameterIsNotNull((Object)boostrapDataSource, (String)"boostrapDataSource");
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"appDatabase");
        this.remoteDataSource = remoteDataSource;
        this.boostrapDataSource = boostrapDataSource;
        this.appDatabase = appDatabase;
        this.latestUpdateSource = UpdateSource.NONE;
        this.dataLastUpdatedChannel = BroadcastChannelKt.BroadcastChannel((int)-1);
        this.dataLastUpdatedObservable = FlowKt.asFlow(this.dataLastUpdatedChannel);
        this.loadConfDataLock = new Object();
    }
}

