/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data;

import android.content.Context;
import com.google.samples.apps.iosched.model.ConferenceData;
import com.google.samples.apps.iosched.shared.data.ConferenceDataDownloader;
import com.google.samples.apps.iosched.shared.data.ConferenceDataJsonParser;
import com.google.samples.apps.iosched.shared.data.ConferenceDataSource;
import com.google.samples.apps.iosched.shared.util.NetworkUtils;
import dagger.hilt.android.qualifiers.ApplicationContext;
import java.io.IOException;
import java.io.InputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/google/samples/apps/iosched/shared/data/NetworkConferenceDataSource;", "Lcom/google/samples/apps/iosched/shared/data/ConferenceDataSource;", "context", "Landroid/content/Context;", "networkUtils", "Lcom/google/samples/apps/iosched/shared/util/NetworkUtils;", "(Landroid/content/Context;Lcom/google/samples/apps/iosched/shared/util/NetworkUtils;)V", "getContext", "()Landroid/content/Context;", "getOfflineConferenceData", "Lcom/google/samples/apps/iosched/model/ConferenceData;", "getRemoteConferenceData", "shared_debug"})
public final class NetworkConferenceDataSource
implements ConferenceDataSource {
    @NotNull
    private final Context context;
    private final NetworkUtils networkUtils;

    @Override
    @Nullable
    public ConferenceData getRemoteConferenceData() {
        ConferenceData conferenceData;
        Response response;
        if (!this.networkUtils.hasNetworkConnection()) {
            Timber.d((String)"Network not connected", (Object[])new Object[0]);
            return null;
        }
        Timber.d((String)"Trying to download data from network", (Object[])new Object[0]);
        try {
            response = new ConferenceDataDownloader(this.context, "1").fetch();
        }
        catch (IOException e) {
            Timber.e((Throwable)e);
            throw (Throwable)e;
        }
        Response responseSource = response;
        Object object = responseSource.body();
        if (object == null || (object = object.byteStream()) == null) {
            return null;
        }
        Object body = object;
        Timber.d((String)"Parsing new data", (Object[])new Object[0]);
        try {
            conferenceData = ConferenceDataJsonParser.INSTANCE.parseConferenceData((InputStream)body);
        }
        catch (RuntimeException e) {
            Timber.e((Throwable)e, (String)"Error parsing cached data", (Object[])new Object[0]);
            conferenceData = null;
        }
        ConferenceData parsedData = conferenceData;
        responseSource.close();
        return parsedData;
    }

    @Override
    @Nullable
    public ConferenceData getOfflineConferenceData() {
        ConferenceData conferenceData;
        InputStream body;
        Response response;
        try {
            response = new ConferenceDataDownloader(this.context, "1").fetchCached();
        }
        catch (IOException e) {
            return null;
        }
        Response responseSource = response;
        Response response2 = responseSource;
        InputStream inputStream = response2 != null && (response2 = response2.body()) != null ? response2.byteStream() : (body = null);
        if (body == null) {
            Timber.i((String)"No cache found", (Object[])new Object[0]);
            return null;
        }
        Timber.d((String)"Parsing cached data:", (Object[])new Object[0]);
        try {
            conferenceData = ConferenceDataJsonParser.INSTANCE.parseConferenceData(body);
        }
        catch (RuntimeException e) {
            Timber.e((Throwable)e, (String)"Error parsing cached data", (Object[])new Object[0]);
            conferenceData = null;
        }
        ConferenceData parsedData = conferenceData;
        responseSource.close();
        return parsedData;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Inject
    public NetworkConferenceDataSource(@ApplicationContext @NotNull Context context, @NotNull NetworkUtils networkUtils) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)networkUtils, (String)"networkUtils");
        this.context = context;
        this.networkUtils = networkUtils;
    }
}

