/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data;

import com.google.samples.apps.iosched.model.ConferenceData;
import com.google.samples.apps.iosched.shared.data.ConferenceDataJsonParser;
import com.google.samples.apps.iosched.shared.data.ConferenceDataSource;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0016J\u0006\u0010\u0006\u001a\u00020\u0004\u00a8\u0006\u0007"}, d2={"Lcom/google/samples/apps/iosched/shared/data/BootstrapConferenceDataSource;", "Lcom/google/samples/apps/iosched/shared/data/ConferenceDataSource;", "()V", "getOfflineConferenceData", "Lcom/google/samples/apps/iosched/model/ConferenceData;", "getRemoteConferenceData", "loadAndParseBootstrapData", "shared_release"})
public final class BootstrapConferenceDataSource
implements ConferenceDataSource {
    public static final BootstrapConferenceDataSource INSTANCE;

    @Override
    @Nullable
    public ConferenceData getRemoteConferenceData() {
        throw (Throwable)new Exception("Bootstrap data source doesn't have remote data");
    }

    @Override
    @Nullable
    public ConferenceData getOfflineConferenceData() {
        return this.loadAndParseBootstrapData();
    }

    @NotNull
    public final ConferenceData loadAndParseBootstrapData() {
        InputStream conferenceDataStream;
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            Intrinsics.throwNpe();
        }
        InputStream inputStream = conferenceDataStream = classLoader.getResource("conference_data_2019.json").openStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"conferenceDataStream");
        return ConferenceDataJsonParser.INSTANCE.parseConferenceData(inputStream);
    }

    private BootstrapConferenceDataSource() {
    }

    static {
        BootstrapConferenceDataSource bootstrapConferenceDataSource;
        INSTANCE = bootstrapConferenceDataSource = new BootstrapConferenceDataSource();
    }
}

