/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data.db;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.FtsTableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import com.google.samples.apps.iosched.shared.data.db.AppDatabase;
import com.google.samples.apps.iosched.shared.data.db.CodelabFtsDao;
import com.google.samples.apps.iosched.shared.data.db.CodelabFtsDao_Impl;
import com.google.samples.apps.iosched.shared.data.db.SessionFtsDao;
import com.google.samples.apps.iosched.shared.data.db.SessionFtsDao_Impl;
import com.google.samples.apps.iosched.shared.data.db.SpeakerFtsDao;
import com.google.samples.apps.iosched.shared.data.db.SpeakerFtsDao_Impl;
import java.util.HashMap;
import java.util.HashSet;

public final class AppDatabase_Impl
extends AppDatabase {
    private volatile SessionFtsDao _sessionFtsDao;
    private volatile SpeakerFtsDao _speakerFtsDao;
    private volatile CodelabFtsDao _codelabFtsDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(3){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE VIRTUAL TABLE IF NOT EXISTS `sessionsFts` USING FTS4(`sessionId` TEXT NOT NULL, `title` TEXT NOT NULL, `description` TEXT NOT NULL, `speakers` TEXT NOT NULL)");
                _db.execSQL("CREATE VIRTUAL TABLE IF NOT EXISTS `speakersFts` USING FTS4(`speakerId` TEXT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL)");
                _db.execSQL("CREATE VIRTUAL TABLE IF NOT EXISTS `codelabsFts` USING FTS4(`codelabId` TEXT NOT NULL, `title` TEXT NOT NULL, `description` TEXT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '13383c94e630bb2fba40bf6dc741e5fb')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `sessionsFts`");
                _db.execSQL("DROP TABLE IF EXISTS `speakersFts`");
                _db.execSQL("DROP TABLE IF EXISTS `codelabsFts`");
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int _size = AppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(_i)).onDestructiveMigration(_db);
                    }
                }
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int _size = AppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                AppDatabase_Impl.this.mDatabase = _db;
                AppDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (AppDatabase_Impl.this.mCallbacks != null) {
                    int _size = AppDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)AppDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected RoomOpenHelper.ValidationResult onValidateSchema(SupportSQLiteDatabase _db) {
                HashSet<String> _columnsSessionsFts = new HashSet<String>(4);
                _columnsSessionsFts.add("sessionId");
                _columnsSessionsFts.add("title");
                _columnsSessionsFts.add("description");
                _columnsSessionsFts.add("speakers");
                FtsTableInfo _infoSessionsFts = new FtsTableInfo("sessionsFts", _columnsSessionsFts, "CREATE VIRTUAL TABLE IF NOT EXISTS `sessionsFts` USING FTS4(`sessionId` TEXT NOT NULL, `title` TEXT NOT NULL, `description` TEXT NOT NULL, `speakers` TEXT NOT NULL)");
                FtsTableInfo _existingSessionsFts = FtsTableInfo.read((SupportSQLiteDatabase)_db, (String)"sessionsFts");
                if (!_infoSessionsFts.equals((Object)_existingSessionsFts)) {
                    return new RoomOpenHelper.ValidationResult(false, "sessionsFts(com.google.samples.apps.iosched.shared.data.db.SessionFtsEntity).\n Expected:\n" + _infoSessionsFts + "\n Found:\n" + _existingSessionsFts);
                }
                HashSet<String> _columnsSpeakersFts = new HashSet<String>(3);
                _columnsSpeakersFts.add("speakerId");
                _columnsSpeakersFts.add("name");
                _columnsSpeakersFts.add("description");
                FtsTableInfo _infoSpeakersFts = new FtsTableInfo("speakersFts", _columnsSpeakersFts, "CREATE VIRTUAL TABLE IF NOT EXISTS `speakersFts` USING FTS4(`speakerId` TEXT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL)");
                FtsTableInfo _existingSpeakersFts = FtsTableInfo.read((SupportSQLiteDatabase)_db, (String)"speakersFts");
                if (!_infoSpeakersFts.equals((Object)_existingSpeakersFts)) {
                    return new RoomOpenHelper.ValidationResult(false, "speakersFts(com.google.samples.apps.iosched.shared.data.db.SpeakerFtsEntity).\n Expected:\n" + _infoSpeakersFts + "\n Found:\n" + _existingSpeakersFts);
                }
                HashSet<String> _columnsCodelabsFts = new HashSet<String>(3);
                _columnsCodelabsFts.add("codelabId");
                _columnsCodelabsFts.add("title");
                _columnsCodelabsFts.add("description");
                FtsTableInfo _infoCodelabsFts = new FtsTableInfo("codelabsFts", _columnsCodelabsFts, "CREATE VIRTUAL TABLE IF NOT EXISTS `codelabsFts` USING FTS4(`codelabId` TEXT NOT NULL, `title` TEXT NOT NULL, `description` TEXT NOT NULL)");
                FtsTableInfo _existingCodelabsFts = FtsTableInfo.read((SupportSQLiteDatabase)_db, (String)"codelabsFts");
                if (!_infoCodelabsFts.equals((Object)_existingCodelabsFts)) {
                    return new RoomOpenHelper.ValidationResult(false, "codelabsFts(com.google.samples.apps.iosched.shared.data.db.CodelabFtsEntity).\n Expected:\n" + _infoCodelabsFts + "\n Found:\n" + _existingCodelabsFts);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "13383c94e630bb2fba40bf6dc741e5fb", "5ebe8fdee7bad71fed45d64b52d0dc29");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap<String, String> _shadowTablesMap = new HashMap<String, String>(3);
        _shadowTablesMap.put("sessionsFts", "sessionsFts_content");
        _shadowTablesMap.put("speakersFts", "speakersFts_content");
        _shadowTablesMap.put("codelabsFts", "codelabsFts_content");
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"sessionsFts", "speakersFts", "codelabsFts"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `sessionsFts`");
            _db.execSQL("DELETE FROM `speakersFts`");
            _db.execSQL("DELETE FROM `codelabsFts`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionFtsDao sessionFtsDao() {
        if (this._sessionFtsDao != null) {
            return this._sessionFtsDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (this._sessionFtsDao == null) {
                this._sessionFtsDao = new SessionFtsDao_Impl(this);
            }
            return this._sessionFtsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpeakerFtsDao speakerFtsDao() {
        if (this._speakerFtsDao != null) {
            return this._speakerFtsDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (this._speakerFtsDao == null) {
                this._speakerFtsDao = new SpeakerFtsDao_Impl(this);
            }
            return this._speakerFtsDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodelabFtsDao codelabFtsDao() {
        if (this._codelabFtsDao != null) {
            return this._codelabFtsDao;
        }
        AppDatabase_Impl appDatabase_Impl = this;
        synchronized (appDatabase_Impl) {
            if (this._codelabFtsDao == null) {
                this._codelabFtsDao = new CodelabFtsDao_Impl(this);
            }
            return this._codelabFtsDao;
        }
    }
}

