/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data;

import android.content.Context;
import androidx.annotation.WorkerThread;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Cache;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0007J\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/google/samples/apps/iosched/shared/data/ConferenceDataDownloader;", "", "context", "Landroid/content/Context;", "bootstrapVersion", "", "(Landroid/content/Context;Ljava/lang/String;)V", "client", "Lokhttp3/OkHttpClient;", "getClient", "()Lokhttp3/OkHttpClient;", "client$delegate", "Lkotlin/Lazy;", "fetch", "Lokhttp3/Response;", "fetchCached", "shared_staging"})
public final class ConferenceDataDownloader {
    private final Lazy client$delegate;
    private final Context context;
    private final String bootstrapVersion;

    private final OkHttpClient getClient() {
        Lazy lazy = this.client$delegate;
        ConferenceDataDownloader conferenceDataDownloader = this;
        Object var3_3 = null;
        boolean bl = false;
        return (OkHttpClient)lazy.getValue();
    }

    @WorkerThread
    @NotNull
    public final Response fetch() throws IOException {
        String url = "https://firebasestorage.googleapis.com/v0/b/io2019-festivus/o/sessions.json?alt=media&token=019af2ec-9fd1-408e-9b86-891e4f66e674";
        Timber.d((String)("Download started from: " + url), (Object[])new Object[0]);
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null || (httpUrl = httpUrl.newBuilder()) == null) {
            throw (Throwable)new IllegalArgumentException("Malformed Session data URL");
        }
        HttpUrl httpBuilder = httpUrl;
        httpBuilder.addQueryParameter("bootstrapVersion", this.bootstrapVersion);
        Request request = new Request.Builder().url(httpBuilder.build()).cacheControl(CacheControl.FORCE_NETWORK).build();
        Response response = this.getClient().newCall(request).execute();
        ResponseBody responseBody = response.body();
        Timber.d((String)("Downloaded bytes: " + (responseBody != null ? responseBody.contentLength() : 0L)), (Object[])new Object[0]);
        Response response2 = response;
        if (response2 == null) {
            throw (Throwable)new IOException("Network error");
        }
        return response2;
    }

    @Nullable
    public final Response fetchCached() {
        String url = "https://firebasestorage.googleapis.com/v0/b/io2019-festivus/o/sessions.json?alt=media&token=019af2ec-9fd1-408e-9b86-891e4f66e674";
        Timber.d((String)("Fetching cached file for url: " + url), (Object[])new Object[0]);
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null || (httpUrl = httpUrl.newBuilder()) == null) {
            throw (Throwable)new IllegalArgumentException("Malformed Session data URL");
        }
        HttpUrl httpBuilder = httpUrl;
        httpBuilder.addQueryParameter("bootstrapVersion", this.bootstrapVersion);
        Request request = new Request.Builder().url(httpBuilder.build()).cacheControl(CacheControl.FORCE_CACHE).build();
        Response response = this.getClient().newCall(request).execute();
        ResponseBody responseBody = response.body();
        Timber.d((String)("Loaded cache. Bytes: " + (responseBody != null ? responseBody.contentLength() : 0L)), (Object[])new Object[0]);
        if (response.code() == 504) {
            return null;
        }
        Response response2 = response;
        if (response2 == null) {
            throw (Throwable)new IOException("Network error");
        }
        return response2;
    }

    public ConferenceDataDownloader(@NotNull Context context, @NotNull String bootstrapVersion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)bootstrapVersion, (String)"bootstrapVersion");
        this.context = context;
        this.bootstrapVersion = bootstrapVersion;
        this.client$delegate = LazyKt.lazy((Function0)((Function0)new Function0<OkHttpClient>(this){
            final /* synthetic */ ConferenceDataDownloader this$0;

            public final OkHttpClient invoke() {
                HttpLoggingInterceptor logInterceptor = new HttpLoggingInterceptor();
                logInterceptor.setLevel(HttpLoggingInterceptor.Level.BASIC);
                ArrayList protocols = CollectionsKt.arrayListOf((Object[])new Protocol[]{Protocol.HTTP_1_1, Protocol.HTTP_2});
                long cacheSize = 0x200000L;
                File cacheDir = ConferenceDataDownloader.access$getContext$p(this.this$0).getDir("conference_data", 0);
                Cache cache = new Cache(cacheDir, cacheSize);
                return new OkHttpClient.Builder().protocols((List)protocols).cache(cache).addInterceptor((Interceptor)logInterceptor).build();
            }
            {
                this.this$0 = conferenceDataDownloader;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Context access$getContext$p(ConferenceDataDownloader $this) {
        return $this.context;
    }
}

