/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data.feed;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.samples.apps.iosched.model.Moment;
import com.google.samples.apps.iosched.shared.data.FirestoreExtensionsKt;
import com.google.samples.apps.iosched.shared.data.feed.MomentDataSource;
import com.google.samples.apps.iosched.shared.util.ColorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/google/samples/apps/iosched/shared/data/feed/FirestoreMomentDataSource;", "Lcom/google/samples/apps/iosched/shared/data/feed/MomentDataSource;", "firestore", "Lcom/google/firebase/firestore/FirebaseFirestore;", "(Lcom/google/firebase/firestore/FirebaseFirestore;)V", "getFirestore", "()Lcom/google/firebase/firestore/FirebaseFirestore;", "getMoments", "", "Lcom/google/samples/apps/iosched/model/Moment;", "parseMomentItem", "snapshot", "Lcom/google/firebase/firestore/DocumentSnapshot;", "Companion", "shared_staging"})
public final class FirestoreMomentDataSource
implements MomentDataSource {
    @NotNull
    private final FirebaseFirestore firestore;
    private static final String MOMENT_COLLECTION = "moments";
    private static final String TITLE = "title";
    private static final String START_TIME = "startTime";
    private static final String END_TIME = "endTime";
    private static final String ATTENDEE_REQUIRED = "attendeeRequired";
    private static final String STREAM_URL = "streamUrl";
    private static final String TEXT_COLOR = "textColor";
    private static final String IMAGE_URL = "imageUrl";
    private static final String IMAGE_URL_DARK = "imageUrlDarkTheme";
    private static final String CTA_TYPE = "ctaType";
    private static final String TIME_VISIBLE = "timeVisible";
    private static final String FEATURE_ID = "featureId";
    private static final String FEATURE_NAME = "featureName";
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Moment> getMoments() {
        void $this$mapTo$iv$iv;
        QuerySnapshot snapshot;
        Task task = FirestoreExtensionsKt.document2020(this.firestore).collection(MOMENT_COLLECTION).get();
        Intrinsics.checkNotNullExpressionValue((Object)task, (String)"firestore\n            .d\u2026CTION)\n            .get()");
        Task task2 = task;
        QuerySnapshot querySnapshot = snapshot = (QuerySnapshot)Tasks.await((Task)task2, (long)20L, (TimeUnit)TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue((Object)querySnapshot, (String)"snapshot");
        List list = querySnapshot.getDocuments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"snapshot.documents");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentSnapshot documentSnapshot = (DocumentSnapshot)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            Moment moment = this.parseMomentItem((DocumentSnapshot)v3);
            collection.add(moment);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Moment it = (Moment)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)it.getStartTime();
                it = (Moment)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                ZonedDateTime zonedDateTime = it.getStartTime();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)zonedDateTime));
            }
        });
    }

    private final Moment parseMomentItem(DocumentSnapshot snapshot) {
        Object object;
        String string;
        Object object2;
        String string2;
        Object object3;
        String string3;
        String string4;
        String string5;
        Object object4;
        String string6;
        String string7 = snapshot.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"snapshot.id");
        Object object5 = snapshot.get(TITLE);
        if (!(object5 instanceof String)) {
            object5 = null;
        }
        if ((string6 = (String)object5) == null) {
            string6 = "";
        }
        if (!((object4 = snapshot.get(STREAM_URL)) instanceof String)) {
            object4 = null;
        }
        if ((string5 = (String)object4) == null) {
            string5 = "";
        }
        Object object6 = snapshot.get(START_TIME);
        if (object6 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.firebase.Timestamp");
        }
        ZonedDateTime zonedDateTime = Instant.ofEpochSecond((long)((Timestamp)object6).getSeconds()).atZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"Instant.ofEpochSecond(\n \u2026e(ZoneId.systemDefault())");
        Object object7 = snapshot.get(END_TIME);
        if (object7 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.google.firebase.Timestamp");
        }
        ZonedDateTime zonedDateTime2 = Instant.ofEpochSecond((long)((Timestamp)object7).getSeconds()).atZone(ZoneId.systemDefault());
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"Instant.ofEpochSecond(\n \u2026e(ZoneId.systemDefault())");
        Object object8 = snapshot.get(TEXT_COLOR);
        if (!(object8 instanceof String)) {
            object8 = null;
        }
        if ((string4 = (String)object8) == null) {
            string4 = "";
        }
        int n = ColorUtils.INSTANCE.parseHexColor(string4);
        Object object9 = snapshot.get(CTA_TYPE);
        if (!(object9 instanceof String)) {
            object9 = null;
        }
        if ((string3 = (String)object9) == null) {
            string3 = "";
        }
        if (!((object3 = snapshot.get(IMAGE_URL)) instanceof String)) {
            object3 = null;
        }
        if ((string2 = (String)object3) == null) {
            string2 = "";
        }
        if (!((object2 = snapshot.get(IMAGE_URL_DARK)) instanceof String)) {
            object2 = null;
        }
        if ((string = (String)object2) == null) {
            string = "";
        }
        if (!((object = snapshot.get(ATTENDEE_REQUIRED)) instanceof Boolean)) {
            object = null;
        }
        Boolean bl = (Boolean)object;
        boolean bl2 = bl != null ? bl : false;
        Object object10 = snapshot.get(TIME_VISIBLE);
        if (!(object10 instanceof Boolean)) {
            object10 = null;
        }
        Boolean bl3 = (Boolean)object10;
        boolean bl4 = bl3 != null ? bl3 : false;
        Object object11 = snapshot.get(FEATURE_ID);
        if (!(object11 instanceof String)) {
            object11 = null;
        }
        String string8 = (String)object11;
        Object object12 = snapshot.get(FEATURE_NAME);
        if (!(object12 instanceof String)) {
            object12 = null;
        }
        String string9 = (String)object12;
        String string10 = string8;
        boolean bl5 = bl4;
        boolean bl6 = bl2;
        String string11 = string;
        String string12 = string2;
        String string13 = string3;
        int n2 = n;
        ZonedDateTime zonedDateTime3 = zonedDateTime2;
        ZonedDateTime zonedDateTime4 = zonedDateTime;
        String string14 = string5;
        return new Moment(string7, string6, zonedDateTime4, zonedDateTime3, bl5, n2, string12, string11, bl6, string13, string10, string9, string14);
    }

    @NotNull
    public final FirebaseFirestore getFirestore() {
        return this.firestore;
    }

    @Inject
    public FirestoreMomentDataSource(@NotNull FirebaseFirestore firestore) {
        Intrinsics.checkNotNullParameter((Object)firestore, (String)"firestore");
        this.firestore = firestore;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/google/samples/apps/iosched/shared/data/feed/FirestoreMomentDataSource$Companion;", "", "()V", "ATTENDEE_REQUIRED", "", "CTA_TYPE", "END_TIME", "FEATURE_ID", "FEATURE_NAME", "IMAGE_URL", "IMAGE_URL_DARK", "MOMENT_COLLECTION", "START_TIME", "STREAM_URL", "TEXT_COLOR", "TIME_VISIBLE", "TITLE", "shared_staging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

