/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data.userevent;

import androidx.annotation.VisibleForTesting;
import com.google.firebase.firestore.DocumentChange;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.QueryDocumentSnapshot;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.samples.apps.iosched.model.userdata.UserEvent;
import com.google.samples.apps.iosched.shared.data.userevent.FirestoreUserEventParserKt;
import com.google.samples.apps.iosched.shared.data.userevent.UserEventMessage;
import com.google.samples.apps.iosched.shared.data.userevent.UserEventMessageChangeType;
import com.google.samples.apps.iosched.shared.data.userevent.UserEventsResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u001a\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001a \u0010\f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006\u00a8\u0006\u0010"}, d2={"compareOldAndNewUserEvents", "Lcom/google/samples/apps/iosched/shared/data/userevent/UserEventMessage;", "oldState", "Lcom/google/samples/apps/iosched/model/userdata/UserEvent;", "newState", "changedId", "", "generateReservationChangeMsg", "snapshot", "Lcom/google/firebase/firestore/QuerySnapshot;", "oldValue", "Lcom/google/samples/apps/iosched/shared/data/userevent/UserEventsResult;", "getUserMessageFromChange", "documentSnapshot", "Lcom/google/firebase/firestore/DocumentSnapshot;", "changeId", "shared_staging"})
public final class UserEventsMessageGeneratorKt {
    @Nullable
    public static final UserEventMessage generateReservationChangeMsg(@NotNull QuerySnapshot snapshot, @Nullable UserEventsResult oldValue) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        if (oldValue == null) {
            return null;
        }
        UserEventMessage userMessage = null;
        List list = snapshot.getDocumentChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"snapshot.documentChanges");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UserEventMessage userMessageSnapshot;
            UserEvent eventOldValue;
            Object v4;
            String changedId;
            DocumentChange change;
            block6: {
                change = (DocumentChange)element$iv;
                boolean bl = false;
                DocumentChange documentChange = change;
                Intrinsics.checkNotNullExpressionValue((Object)documentChange, (String)"change");
                QueryDocumentSnapshot queryDocumentSnapshot = documentChange.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)queryDocumentSnapshot, (String)"change.document");
                Object v = queryDocumentSnapshot.getData().get("id");
                if (!(v instanceof String)) {
                    v = null;
                }
                if ((String)v == null) {
                    return null;
                }
                Iterable $this$firstOrNull$iv = oldValue.getUserEvents();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    UserEvent it = (UserEvent)element$iv2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)changedId)) continue;
                    v4 = element$iv2;
                    break block6;
                }
                v4 = null;
            }
            if ((UserEvent)v4 == null) {
                return null;
            }
            QueryDocumentSnapshot queryDocumentSnapshot = change.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)queryDocumentSnapshot, (String)"change.document");
            UserEventMessage newMessage = UserEventsMessageGeneratorKt.getUserMessageFromChange(eventOldValue, (DocumentSnapshot)queryDocumentSnapshot, changedId);
            if (newMessage == null || (userMessageSnapshot = userMessage) != null && newMessage.getType().compareTo((Enum)userMessageSnapshot.getType()) >= 0) continue;
            userMessage = newMessage;
        }
        return userMessage;
    }

    @Nullable
    public static final UserEventMessage getUserMessageFromChange(@NotNull UserEvent oldValue, @NotNull DocumentSnapshot documentSnapshot, @NotNull String changeId) {
        Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
        Intrinsics.checkNotNullParameter((Object)documentSnapshot, (String)"documentSnapshot");
        Intrinsics.checkNotNullParameter((Object)changeId, (String)"changeId");
        UserEvent newState = FirestoreUserEventParserKt.parseUserEvent(documentSnapshot);
        return UserEventsMessageGeneratorKt.compareOldAndNewUserEvents(oldValue, newState, changeId);
    }

    @VisibleForTesting
    @Nullable
    public static final UserEventMessage compareOldAndNewUserEvents(@NotNull UserEvent oldState, @NotNull UserEvent newState, @NotNull String changedId) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        Intrinsics.checkNotNullParameter((Object)changedId, (String)"changedId");
        if (!oldState.isReserved() && newState.isReserved()) {
            Timber.d((String)("Request change detected: " + changedId), (Object[])new Object[0]);
            return newState.isLastRequestResultBySwap() ? new UserEventMessage(UserEventMessageChangeType.RESERVATIONS_REPLACED, newState.getId(), newState.getReservationRequestResultId()) : new UserEventMessage(UserEventMessageChangeType.CHANGES_IN_RESERVATIONS, newState.getId(), newState.getReservationRequestResultId());
        }
        if (oldState.isReservationPending() && newState.isWaitlisted()) {
            Timber.d((String)("Waitlist change detected: " + changedId), (Object[])new Object[0]);
            return new UserEventMessage(UserEventMessageChangeType.CHANGES_IN_WAITLIST, newState.getId(), newState.getReservationRequestResultId());
        }
        if (oldState.isReserved() && !newState.isReserved()) {
            Timber.d((String)("Reservation cancellation detected: " + changedId), (Object[])new Object[0]);
            return new UserEventMessage(UserEventMessageChangeType.RESERVATION_CANCELED, newState.getId(), newState.getReservationRequestResultId());
        }
        if (oldState.isWaitlisted() && !newState.isReserved() && !newState.isWaitlisted()) {
            Timber.d((String)("Reservation cancellation detected: " + changedId), (Object[])new Object[0]);
            return new UserEventMessage(UserEventMessageChangeType.WAITLIST_CANCELED, newState.getId(), newState.getReservationRequestResultId());
        }
        if (newState.hasRequestResultError() && newState.isDifferentRequestResult(oldState.getReservationRequestResultId())) {
            if (newState.isRequestResultErrorReserveDeniedCutoff()) {
                Timber.d((String)("Reservation error cut-off: " + changedId), (Object[])new Object[0]);
                return new UserEventMessage(UserEventMessageChangeType.RESERVATION_DENIED_CUTOFF, newState.getId(), newState.getReservationRequestResultId());
            }
            if (newState.isRequestResultErrorReserveDeniedClash()) {
                Timber.d((String)("Reservation error clash: " + changedId), (Object[])new Object[0]);
                return new UserEventMessage(UserEventMessageChangeType.RESERVATION_DENIED_CLASH, newState.getId(), newState.getReservationRequestResultId());
            }
            if (newState.isRequestResultErrorReserveDeniedUnknown()) {
                Timber.d((String)("Reservation unknown error: " + changedId), (Object[])new Object[0]);
                return new UserEventMessage(UserEventMessageChangeType.RESERVATION_DENIED_UNKNOWN, newState.getId(), newState.getReservationRequestResultId());
            }
            if (newState.isRequestResultErrorCancelDeniedCutoff()) {
                Timber.d((String)("Cancellation error cut-off: " + changedId), (Object[])new Object[0]);
                return new UserEventMessage(UserEventMessageChangeType.CANCELLATION_DENIED_CUTOFF, newState.getId(), newState.getReservationRequestResultId());
            }
            if (newState.isRequestResultErrorCancelDeniedUnknown()) {
                Timber.d((String)("Cancellation unknown error: " + changedId), (Object[])new Object[0]);
                return new UserEventMessage(UserEventMessageChangeType.CANCELLATION_DENIED_UNKNOWN, newState.getId(), newState.getReservationRequestResultId());
            }
        }
        return null;
    }
}

