/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.notifications;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import androidx.annotation.RequiresApi;
import androidx.annotation.WorkerThread;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.google.samples.apps.iosched.model.Session;
import com.google.samples.apps.iosched.model.userdata.UserSession;
import com.google.samples.apps.iosched.shared.R;
import com.google.samples.apps.iosched.shared.data.prefs.SharedPreferenceStorage;
import com.google.samples.apps.iosched.shared.data.signin.datasources.AuthIdDataSource;
import com.google.samples.apps.iosched.shared.di.ApplicationScope;
import com.google.samples.apps.iosched.shared.domain.sessions.LoadSessionOneShotUseCase;
import com.google.samples.apps.iosched.shared.domain.sessions.LoadUserSessionOneShotUseCase;
import com.google.samples.apps.iosched.shared.notifications.AlarmBroadcastReceiver;
import com.google.samples.apps.iosched.shared.notifications.Hilt_AlarmBroadcastReceiver;
import com.google.samples.apps.iosched.shared.notifications.SessionAlarmManager;
import com.google.samples.apps.iosched.shared.result.Result;
import dagger.hilt.android.AndroidEntryPoint;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.Instant;
import timber.log.Timber;

@AndroidEntryPoint
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 E2\u00020\u0001:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J)\u00100\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0083@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J)\u00101\u001a\n\u0012\u0004\u0012\u000203\u0018\u0001022\u0006\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020-H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010:\u001a\u00020;H\u0003J\u0018\u0010<\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010:\u001a\u00020;H\u0003J!\u0010=\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010*\u001a\u00020+H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010>J\u0018\u0010?\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010@\u001a\u00020AH\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010*\u001a\u00020+2\u0006\u00107\u001a\u000208H\u0003J\u0018\u0010D\u001a\u00020C2\u0006\u0010*\u001a\u00020+2\u0006\u00107\u001a\u000208H\u0003R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u00020\n8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\u00108\u0006@\u0006X\u0087.\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\u00178\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001e\u0010\u001c\u001a\u00020\u001d8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001e\u0010\"\u001a\u00020#8\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006F"}, d2={"Lcom/google/samples/apps/iosched/shared/notifications/AlarmBroadcastReceiver;", "Landroid/content/BroadcastReceiver;", "()V", "alarmManager", "Lcom/google/samples/apps/iosched/shared/notifications/SessionAlarmManager;", "getAlarmManager", "()Lcom/google/samples/apps/iosched/shared/notifications/SessionAlarmManager;", "setAlarmManager", "(Lcom/google/samples/apps/iosched/shared/notifications/SessionAlarmManager;)V", "authIdDataSource", "Lcom/google/samples/apps/iosched/shared/data/signin/datasources/AuthIdDataSource;", "getAuthIdDataSource", "()Lcom/google/samples/apps/iosched/shared/data/signin/datasources/AuthIdDataSource;", "setAuthIdDataSource", "(Lcom/google/samples/apps/iosched/shared/data/signin/datasources/AuthIdDataSource;)V", "externalScope", "Lkotlinx/coroutines/CoroutineScope;", "getExternalScope$annotations", "getExternalScope", "()Lkotlinx/coroutines/CoroutineScope;", "setExternalScope", "(Lkotlinx/coroutines/CoroutineScope;)V", "loadSession", "Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadSessionOneShotUseCase;", "getLoadSession", "()Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadSessionOneShotUseCase;", "setLoadSession", "(Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadSessionOneShotUseCase;)V", "loadUserSession", "Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadUserSessionOneShotUseCase;", "getLoadUserSession", "()Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadUserSessionOneShotUseCase;", "setLoadUserSession", "(Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadUserSessionOneShotUseCase;)V", "sharedPreferencesStorage", "Lcom/google/samples/apps/iosched/shared/data/prefs/SharedPreferenceStorage;", "getSharedPreferencesStorage", "()Lcom/google/samples/apps/iosched/shared/data/prefs/SharedPreferenceStorage;", "setSharedPreferencesStorage", "(Lcom/google/samples/apps/iosched/shared/data/prefs/SharedPreferenceStorage;)V", "checkThenShowPostSessionNotification", "", "context", "Landroid/content/Context;", "sessionId", "", "userId", "(Landroid/content/Context;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkThenShowPreSessionNotification", "getUserEvent", "Lcom/google/samples/apps/iosched/shared/result/Result;", "Lcom/google/samples/apps/iosched/model/userdata/UserSession;", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isSessionCurrent", "", "session", "Lcom/google/samples/apps/iosched/model/Session;", "makeNotificationChannelForPostSession", "notificationManager", "Landroid/app/NotificationManager;", "makeNotificationChannelForPreSession", "notifyWithoutUserEvent", "(Ljava/lang/String;Landroid/content/Context;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "onReceive", "intent", "Landroid/content/Intent;", "showPostSessionNotification", "", "showPreSessionNotification", "Companion", "shared_staging"})
public final class AlarmBroadcastReceiver
extends Hilt_AlarmBroadcastReceiver {
    @Inject
    public SharedPreferenceStorage sharedPreferencesStorage;
    @Inject
    public LoadUserSessionOneShotUseCase loadUserSession;
    @Inject
    public LoadSessionOneShotUseCase loadSession;
    @Inject
    public SessionAlarmManager alarmManager;
    @Inject
    public AuthIdDataSource authIdDataSource;
    @Inject
    public CoroutineScope externalScope;
    @NotNull
    public static final String EXTRA_NOTIFICATION_CHANNEL = "notification_channel";
    @NotNull
    public static final String EXTRA_SESSION_ID = "user_event_extra";
    @NotNull
    public static final String EXTRA_SHOW_RATE_SESSION_FLAG = "show_rate_session_extra";
    @NotNull
    public static final String QUERY_SESSION_ID = "session_id";
    @NotNull
    public static final String CHANNEL_ID_UPCOMING = "upcoming_channel_id";
    @NotNull
    public static final String CHANNEL_ID_FEEDBACK = "feedback_channel_id";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final SharedPreferenceStorage getSharedPreferencesStorage() {
        SharedPreferenceStorage sharedPreferenceStorage = this.sharedPreferencesStorage;
        if (sharedPreferenceStorage == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferencesStorage");
        }
        return sharedPreferenceStorage;
    }

    public final void setSharedPreferencesStorage(@NotNull SharedPreferenceStorage sharedPreferenceStorage) {
        Intrinsics.checkNotNullParameter((Object)sharedPreferenceStorage, (String)"<set-?>");
        this.sharedPreferencesStorage = sharedPreferenceStorage;
    }

    @NotNull
    public final LoadUserSessionOneShotUseCase getLoadUserSession() {
        LoadUserSessionOneShotUseCase loadUserSessionOneShotUseCase = this.loadUserSession;
        if (loadUserSessionOneShotUseCase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadUserSession");
        }
        return loadUserSessionOneShotUseCase;
    }

    public final void setLoadUserSession(@NotNull LoadUserSessionOneShotUseCase loadUserSessionOneShotUseCase) {
        Intrinsics.checkNotNullParameter((Object)loadUserSessionOneShotUseCase, (String)"<set-?>");
        this.loadUserSession = loadUserSessionOneShotUseCase;
    }

    @NotNull
    public final LoadSessionOneShotUseCase getLoadSession() {
        LoadSessionOneShotUseCase loadSessionOneShotUseCase = this.loadSession;
        if (loadSessionOneShotUseCase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"loadSession");
        }
        return loadSessionOneShotUseCase;
    }

    public final void setLoadSession(@NotNull LoadSessionOneShotUseCase loadSessionOneShotUseCase) {
        Intrinsics.checkNotNullParameter((Object)loadSessionOneShotUseCase, (String)"<set-?>");
        this.loadSession = loadSessionOneShotUseCase;
    }

    @NotNull
    public final SessionAlarmManager getAlarmManager() {
        SessionAlarmManager sessionAlarmManager = this.alarmManager;
        if (sessionAlarmManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"alarmManager");
        }
        return sessionAlarmManager;
    }

    public final void setAlarmManager(@NotNull SessionAlarmManager sessionAlarmManager) {
        Intrinsics.checkNotNullParameter((Object)sessionAlarmManager, (String)"<set-?>");
        this.alarmManager = sessionAlarmManager;
    }

    @NotNull
    public final AuthIdDataSource getAuthIdDataSource() {
        AuthIdDataSource authIdDataSource = this.authIdDataSource;
        if (authIdDataSource == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"authIdDataSource");
        }
        return authIdDataSource;
    }

    public final void setAuthIdDataSource(@NotNull AuthIdDataSource authIdDataSource) {
        Intrinsics.checkNotNullParameter((Object)authIdDataSource, (String)"<set-?>");
        this.authIdDataSource = authIdDataSource;
    }

    @ApplicationScope
    public static /* synthetic */ void getExternalScope$annotations() {
    }

    @NotNull
    public final CoroutineScope getExternalScope() {
        CoroutineScope coroutineScope = this.externalScope;
        if (coroutineScope == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"externalScope");
        }
        return coroutineScope;
    }

    public final void setExternalScope(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"<set-?>");
        this.externalScope = coroutineScope;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void onReceive(@NotNull Context var1_1, @NotNull Intent var2_2) {
        block10: {
            block9: {
                super.onReceive(var1_1, var2_2);
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                Timber.d((String)"Alarm received", (Object[])new Object[0]);
                v0 = intent.getStringExtra("user_event_extra");
                if (v0 == null) {
                    return;
                }
                sessionId = v0;
                v1 = this.authIdDataSource;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"authIdDataSource");
                }
                v2 = v1.getUserId();
                if (v2 == null) {
                    var5_4 = this;
                    var6_6 = false;
                    var7_8 = false;
                    $this$run = var5_4;
                    $i$a$-run-AlarmBroadcastReceiver$onReceive$userId$1 = false;
                    Timber.e((String)"No user ID, not showing notification.", (Object[])new Object[0]);
                    return;
                }
                userId = v2;
                v3 = channel = intent.getStringExtra("notification_channel");
                if (v3 == null) break block9;
                var6_7 = v3;
                switch (var6_7.hashCode()) {
                    case -1406359855: {
                        if (!var6_7.equals("feedback_channel_id")) ** break;
                        break;
                    }
                    case 1200911578: {
                        if (!var6_7.equals("upcoming_channel_id")) ** break;
                        v4 = this.externalScope;
                        if (v4 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"externalScope");
                        }
                        BuildersKt.launch$default((CoroutineScope)v4, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Context)context, sessionId, userId, null){
                            int label;
                            final /* synthetic */ AlarmBroadcastReceiver this$0;
                            final /* synthetic */ Context $context;
                            final /* synthetic */ String $sessionId;
                            final /* synthetic */ String $userId;

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        this.label = 1;
                                        Object object3 = this.this$0.checkThenShowPreSessionNotification(this.$context, this.$sessionId, this.$userId, (Continuation<? super Unit>)this);
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }
                            {
                                this.this$0 = alarmBroadcastReceiver;
                                this.$context = context;
                                this.$sessionId = string2;
                                this.$userId = string3;
                                super(2, continuation);
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                return function2;
                            }

                            public final Object invoke(Object object, Object object2) {
                                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        break block10;
                    }
                }
                v5 = this.externalScope;
                if (v5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"externalScope");
                }
                BuildersKt.launch$default((CoroutineScope)v5, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (Context)context, sessionId, userId, null){
                    int label;
                    final /* synthetic */ AlarmBroadcastReceiver this$0;
                    final /* synthetic */ Context $context;
                    final /* synthetic */ String $sessionId;
                    final /* synthetic */ String $userId;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.checkThenShowPostSessionNotification(this.$context, this.$sessionId, this.$userId, (Continuation<? super Unit>)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = alarmBroadcastReceiver;
                        this.$context = context;
                        this.$sessionId = string2;
                        this.$userId = string3;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
                break block10;
            }
            Timber.w((String)("Broadcast with unknown channel received: " + channel), (Object[])new Object[0]);
        }
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final /* synthetic */ Object checkThenShowPreSessionNotification(Context var1_1, String var2_2, String var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof checkThenShowPreSessionNotification.1)) ** GOTO lbl-1000
        var9_5 = var4_4;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlarmBroadcastReceiver this$0;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkThenShowPreSessionNotification(null, null, null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = alarmBroadcastReceiver;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.sharedPreferencesStorage;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferencesStorage");
                }
                if (!v0.getPreferToReceiveNotifications()) {
                    Timber.d((String)"User disabled notifications, not showing", (Object[])new Object[0]);
                    return Unit.INSTANCE;
                }
                Timber.d((String)("Showing pre session notification for " + sessionId + ", user " + (String)userId), (Object[])new Object[0]);
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.L$2 = sessionId;
                $continuation.label = 1;
                v1 = this.getUserEvent((String)userId, sessionId, (Continuation<? super Result<UserSession>>)$continuation);
                if (v1 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl33
            }
            case 1: {
                sessionId = (String)$continuation.L$2;
                context = (Context)$continuation.L$1;
                this = (AlarmBroadcastReceiver)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl33:
                // 2 sources

                if (!((userEvent = (Result)v1) instanceof Result.Success)) ** GOTO lbl48
                event = ((UserSession)((Result.Success)userEvent).getData()).getUserEvent();
                if (!event.isPreSessionNotificationRequired() || !this.isSessionCurrent(((UserSession)((Result.Success)userEvent).getData()).getSession())) ** GOTO lbl59
                try {
                    notificationId = this.showPreSessionNotification(context, ((UserSession)((Result.Success)userEvent).getData()).getSession());
                    v2 = this.alarmManager;
                    if (v2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"alarmManager");
                    }
                    v2.dismissNotificationInFiveMinutes(notificationId);
                    ** GOTO lbl59
                }
                catch (Exception ex) {
                    Timber.e((Throwable)ex);
                    return Unit.INSTANCE;
                }
lbl48:
                // 1 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.label = 2;
                v3 = this.notifyWithoutUserEvent(sessionId, context, (Continuation<? super Unit>)$continuation);
                if (v3 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl59
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl59:
                // 4 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @WorkerThread
    final /* synthetic */ Object checkThenShowPostSessionNotification(Context var1_1, String var2_2, String var3_3, Continuation<? super Unit> var4_4) {
        if (!(var4_4 instanceof checkThenShowPostSessionNotification.1)) ** GOTO lbl-1000
        var10_5 = var4_4;
        if ((var10_5.label & -2147483648) != 0) {
            var10_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlarmBroadcastReceiver this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkThenShowPostSessionNotification(null, null, null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = alarmBroadcastReceiver;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var11_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.sharedPreferencesStorage;
                if (v0 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"sharedPreferencesStorage");
                }
                if (!v0.getPreferToReceiveNotifications()) {
                    Timber.d((String)"User disabled notifications, not showing", (Object[])new Object[0]);
                    return Unit.INSTANCE;
                }
                Timber.d((String)("Showing post session notification for " + (String)sessionId + ", user " + (String)userId), (Object[])new Object[0]);
                $continuation.L$0 = this;
                $continuation.L$1 = context;
                $continuation.label = 1;
                v1 = this.getUserEvent((String)userId, (String)sessionId, (Continuation<? super Result<UserSession>>)$continuation);
                if (v1 == var11_7) {
                    return var11_7;
                }
                ** GOTO lbl31
            }
            case 1: {
                context = (Context)$continuation.L$1;
                this = (AlarmBroadcastReceiver)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl31:
                // 2 sources

                if (!((v2 = (userEvent = (Result)v1)) instanceof Result.Success)) {
                    v2 = null;
                }
                if ((v3 = (Result.Success)v2) == null || (v3 = (UserSession)v3.getData()) == null) {
                    return Unit.INSTANCE;
                }
                userSession = v3;
                now = Instant.now();
                if (userSession.isPostSessionNotificationRequired() && now.isAfter(userSession.getSession().getEndTime().toInstant())) {
                    try {
                        this.showPostSessionNotification(context, ((UserSession)((Result.Success)userEvent).getData()).getSession());
                    }
                    catch (Exception ex) {
                        Timber.e((Throwable)ex);
                        return Unit.INSTANCE;
                    }
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ Object notifyWithoutUserEvent(String var1_1, Context var2_2, Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof notifyWithoutUserEvent.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlarmBroadcastReceiver this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.notifyWithoutUserEvent(null, null, (Continuation<? super Unit>)this);
                }
                {
                    this.this$0 = alarmBroadcastReceiver;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (String)sessionId, (Context)context, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ AlarmBroadcastReceiver this$0;
                    final /* synthetic */ String $sessionId;
                    final /* synthetic */ Context $context;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$coroutineScope = (CoroutineScope)this.L$0;
                                this.label = 1;
                                v0 = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends Session>>, Object>(this, null){
                                    int label;
                                    final /* synthetic */ notifyWithoutUserEvent.2 this$0;

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.this$0.this$0.getLoadSession().invoke(this.this$0.$sessionId, this);
                                                if (object3 != object2) return object3;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return object3;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Result<? extends Session>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null).await((Continuation)this);
                                if (v0 == var5_2) {
                                    return var5_2;
                                }
                                ** GOTO lbl14
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl14:
                                // 2 sources

                                if ((session = (Result)v0) instanceof Result.Success) {
                                    notificationId = AlarmBroadcastReceiver.access$showPreSessionNotification(this.this$0, this.$context, (Session)((Result.Success)session).getData());
                                    this.this$0.getAlarmManager().dismissNotificationInFiveMinutes(notificationId);
                                } else {
                                    Timber.e((String)"Session couldn't be loaded for notification", (Object[])new Object[0]);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = alarmBroadcastReceiver;
                        this.$sessionId = string2;
                        this.$context = context;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function2.L$0 = value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var8_6) goto lbl18
lbl17:
                // 1 sources

                return var8_6;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    var4_7 = Unit.INSTANCE;
                }
                catch (Exception ex) {
                    Timber.e((String)("Exception loading session for notification: " + ex.getMessage()), (Object[])new Object[0]);
                    var4_7 = Unit.INSTANCE;
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    final /* synthetic */ Object getUserEvent(String var1_1, String var2_2, Continuation<? super Result<UserSession>> var3_3) {
        if (!(var3_3 instanceof getUserEvent.1)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ AlarmBroadcastReceiver this$0;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.getUserEvent(null, null, (Continuation<? super Result<UserSession>>)this);
                }
                {
                    this.this$0 = alarmBroadcastReceiver;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends UserSession>>, Object>(this, (String)userId, (String)sessionId, null){
                    private /* synthetic */ Object L$0;
                    int label;
                    final /* synthetic */ AlarmBroadcastReceiver this$0;
                    final /* synthetic */ String $userId;
                    final /* synthetic */ String $sessionId;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                                this.label = 1;
                                Object object3 = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Result<? extends UserSession>>, Object>(this, null){
                                    int label;
                                    final /* synthetic */ getUserEvent.2 this$0;

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.this$0.this$0.getLoadUserSession().invoke(TuplesKt.to((Object)this.this$0.$userId, (Object)this.this$0.$sessionId), this);
                                                if (object3 != object2) return object3;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return object3;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Result<? extends UserSession>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (int)3, null).await((Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = alarmBroadcastReceiver;
                        this.$userId = string2;
                        this.$sessionId = string3;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Result<? extends UserSession>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        Object object = function2.L$0 = value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var8_6) goto lbl18
lbl17:
                // 1 sources

                return var8_6;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl24:
                    // 2 sources

                    var4_7 = (Result)v0;
                }
                catch (Exception var5_8) {
                    Timber.e((String)"Session notification is set, however there was an error confirming\nthat the event is still starred. Showing notification.", (Object[])new Object[0]);
                    var4_7 = null;
                }
                return var4_7;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @WorkerThread
    private final int showPreSessionNotification(Context context, Session session2) {
        Context $this$getSystemService$iv = context;
        boolean $i$f$getSystemService = false;
        NotificationManager notificationManager = (NotificationManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, NotificationManager.class);
        if (notificationManager == null) {
            throw (Throwable)new Exception("Notification Manager not found.");
        }
        NotificationManager notificationManager2 = notificationManager;
        if (Build.VERSION.SDK_INT >= 26) {
            this.makeNotificationChannelForPreSession(context, notificationManager2);
        }
        String $this$toUri$iv = "iosched://sessions?session_id=" + session2.getId();
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(this)");
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        intent.setFlags(0x10000000);
        PendingIntent resultPendingIntent = TaskStackBuilder.create((Context)context).addNextIntentWithParentStack(intent).getPendingIntent(0, 0x8000000);
        Notification notification = new NotificationCompat.Builder(context, CHANNEL_ID_UPCOMING).setContentTitle((CharSequence)session2.getTitle()).setContentText((CharSequence)context.getString(R.string.starting_soon)).setSmallIcon(R.drawable.ic_notification_io_logo).setContentIntent(resultPendingIntent).setTimeoutAfter(TimeUnit.MINUTES.toMillis(10L)).setAutoCancel(true).setVisibility(1).build();
        int notificationId = session2.getId().hashCode();
        notificationManager2.notify(notificationId, notification);
        return notificationId;
    }

    @WorkerThread
    private final int showPostSessionNotification(Context context, Session session2) {
        Context $this$getSystemService$iv = context;
        boolean $i$f$getSystemService = false;
        NotificationManager notificationManager = (NotificationManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, NotificationManager.class);
        if (notificationManager == null) {
            throw (Throwable)new Exception("Notification Manager not found.");
        }
        NotificationManager notificationManager2 = notificationManager;
        if (Build.VERSION.SDK_INT >= 26) {
            this.makeNotificationChannelForPostSession(context, notificationManager2);
        }
        String $this$toUri$iv = "iosched://sessions?session_id=" + session2.getId();
        boolean $i$f$toUri = false;
        Uri uri = Uri.parse((String)$this$toUri$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)uri, (String)"Uri.parse(this)");
        $this$toUri$iv = new Intent("android.intent.action.VIEW", uri);
        $i$f$toUri = false;
        boolean bl = false;
        String $this$apply = $this$toUri$iv;
        boolean bl2 = false;
        $this$apply.setFlags(0x10000000);
        $this$apply.putExtra(EXTRA_SHOW_RATE_SESSION_FLAG, true);
        String intent = $this$toUri$iv;
        PendingIntent resultPendingIntent = TaskStackBuilder.create((Context)context).addNextIntentWithParentStack((Intent)intent).getPendingIntent(0, 0x8000000);
        Notification notification = new NotificationCompat.Builder(context, CHANNEL_ID_FEEDBACK).setContentTitle((CharSequence)session2.getTitle()).setContentText((CharSequence)context.getString(R.string.please_rate_session)).setSmallIcon(R.drawable.ic_notification_io_logo).setContentIntent(resultPendingIntent).setTimeoutAfter(TimeUnit.MINUTES.toMillis(20L)).setAutoCancel(true).setVisibility(1).build();
        int notificationId = session2.getId().hashCode();
        notificationManager2.notify(notificationId, notification);
        return notificationId;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    private final void makeNotificationChannelForPreSession(Context context, NotificationManager notificationManager) {
        void $this$apply;
        NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID_UPCOMING, (CharSequence)context.getString(R.string.session_notifications), 3);
        boolean bl = false;
        boolean bl2 = false;
        NotificationChannel notificationChannel2 = notificationChannel;
        NotificationManager notificationManager2 = notificationManager;
        boolean bl3 = false;
        $this$apply.setLockscreenVisibility(1);
        Unit unit = Unit.INSTANCE;
        notificationManager2.createNotificationChannel(notificationChannel);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(value=26)
    private final void makeNotificationChannelForPostSession(Context context, NotificationManager notificationManager) {
        void $this$apply;
        NotificationChannel notificationChannel = new NotificationChannel(CHANNEL_ID_FEEDBACK, (CharSequence)context.getString(R.string.session_feedback_notifications), 2);
        boolean bl = false;
        boolean bl2 = false;
        NotificationChannel notificationChannel2 = notificationChannel;
        NotificationManager notificationManager2 = notificationManager;
        boolean bl3 = false;
        $this$apply.setLockscreenVisibility(1);
        Unit unit = Unit.INSTANCE;
        notificationManager2.createNotificationChannel(notificationChannel);
    }

    private final boolean isSessionCurrent(Session session2) {
        return session2.getStartTime().toInstant().isAfter(Instant.now());
    }

    public static final /* synthetic */ int access$showPreSessionNotification(AlarmBroadcastReceiver $this, Context context, Session session2) {
        return $this.showPreSessionNotification(context, session2);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/samples/apps/iosched/shared/notifications/AlarmBroadcastReceiver$Companion;", "", "()V", "CHANNEL_ID_FEEDBACK", "", "CHANNEL_ID_UPCOMING", "EXTRA_NOTIFICATION_CHANNEL", "EXTRA_SESSION_ID", "EXTRA_SHOW_RATE_SESSION_FLAG", "QUERY_SESSION_ID", "shared_staging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

