/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.notifications;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import androidx.core.app.AlarmManagerCompat;
import androidx.core.content.ContextCompat;
import com.google.samples.apps.iosched.model.Session;
import com.google.samples.apps.iosched.model.userdata.UserSession;
import com.google.samples.apps.iosched.shared.notifications.AlarmBroadcastReceiver;
import com.google.samples.apps.iosched.shared.notifications.CancelNotificationBroadcastReceiver;
import com.google.samples.apps.iosched.shared.util.ExtensionsKt;
import dagger.hilt.android.qualifiers.ApplicationContext;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.threeten.bp.Instant;
import org.threeten.bp.temporal.ChronoUnit;
import org.threeten.bp.temporal.TemporalUnit;
import timber.log.Timber;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000  2\u00020\u0001:\u0001 B\u0011\b\u0007\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\n2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u0004\u0018\u00010\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J(\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u000fH\u0002J\u0018\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/google/samples/apps/iosched/shared/notifications/SessionAlarmManager;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "systemAlarmManager", "Landroid/app/AlarmManager;", "cancelAlarmFor", "", "pendingIntent", "Landroid/app/PendingIntent;", "cancelAlarmForSession", "sessionId", "", "Lcom/google/samples/apps/iosched/model/SessionId;", "dismissNotificationInFiveMinutes", "notificationId", "", "makePendingIntent", "channel", "scheduleAlarmFor", "session", "Lcom/google/samples/apps/iosched/model/Session;", "triggerAtMillis", "", "scheduleAlarmForPostSession", "scheduleAlarmForPreSession", "setAlarmForSession", "userSession", "Lcom/google/samples/apps/iosched/model/userdata/UserSession;", "Companion", "shared_staging"})
public class SessionAlarmManager {
    private final AlarmManager systemAlarmManager;
    @NotNull
    private final Context context;
    private static final long alarmTimeDelta;
    @NotNull
    public static final Companion Companion;

    public final void setAlarmForSession(@NotNull UserSession userSession) {
        block3: {
            PendingIntent feedbackIntent;
            boolean bl;
            PendingIntent upcomingIntent;
            Intrinsics.checkNotNullParameter((Object)userSession, (String)"userSession");
            Session session2 = userSession.getSession();
            if (session2.getStartTime().toInstant().minusMillis(alarmTimeDelta).isBefore(Instant.now())) {
                Timber.d((String)"Trying to schedule an alarm for a past session, ignoring.", (Object[])new Object[0]);
                return;
            }
            this.cancelAlarmForSession(session2.getId());
            PendingIntent pendingIntent = upcomingIntent = this.makePendingIntent(session2.getId(), "upcoming_channel_id");
            if (pendingIntent != null) {
                PendingIntent pendingIntent2 = pendingIntent;
                boolean bl2 = false;
                bl = false;
                PendingIntent it = pendingIntent2;
                boolean bl3 = false;
                this.scheduleAlarmForPreSession(it, session2);
            }
            if (!userSession.isPostSessionNotificationRequired()) break block3;
            PendingIntent pendingIntent3 = feedbackIntent = this.makePendingIntent(session2.getId(), "feedback_channel_id");
            if (pendingIntent3 != null) {
                PendingIntent pendingIntent4 = pendingIntent3;
                bl = false;
                boolean bl4 = false;
                PendingIntent it = pendingIntent4;
                boolean bl5 = false;
                this.scheduleAlarmForPostSession(it, session2);
            }
        }
    }

    public void cancelAlarmForSession(@NotNull String sessionId) {
        block1: {
            PendingIntent feedbackIntent;
            boolean bl;
            PendingIntent upcomingIntent;
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            PendingIntent pendingIntent = upcomingIntent = this.makePendingIntent(sessionId, "upcoming_channel_id");
            if (pendingIntent != null) {
                PendingIntent pendingIntent2 = pendingIntent;
                boolean bl2 = false;
                bl = false;
                PendingIntent it = pendingIntent2;
                boolean bl3 = false;
                this.cancelAlarmFor(it);
                Timber.d((String)("Cancelled upcoming alarm for session " + sessionId), (Object[])new Object[0]);
            }
            PendingIntent pendingIntent3 = feedbackIntent = this.makePendingIntent(sessionId, "feedback_channel_id");
            if (pendingIntent3 == null) break block1;
            PendingIntent pendingIntent4 = pendingIntent3;
            bl = false;
            boolean bl4 = false;
            PendingIntent it = pendingIntent4;
            boolean bl5 = false;
            this.cancelAlarmFor(it);
            Timber.d((String)("Cancelled feedback alarm for session " + sessionId), (Object[])new Object[0]);
        }
    }

    private final PendingIntent makePendingIntent(String sessionId, String channel) {
        return PendingIntent.getBroadcast((Context)this.context, (int)(sessionId + channel).hashCode(), (Intent)new Intent(this.context, AlarmBroadcastReceiver.class).putExtra("user_event_extra", sessionId).putExtra("notification_channel", channel), (int)0x8000000);
    }

    private final void cancelAlarmFor(PendingIntent pendingIntent) {
        try {
            AlarmManager alarmManager = this.systemAlarmManager;
            if (alarmManager != null) {
                alarmManager.cancel(pendingIntent);
            }
        }
        catch (Exception ex) {
            Timber.e((String)"Couldn't cancel alarm for session", (Object[])new Object[0]);
        }
    }

    private final void scheduleAlarmForPreSession(PendingIntent pendingIntent, Session session2) {
        long triggerAtMillis = ExtensionsKt.toEpochMilli(session2.getStartTime()) - alarmTimeDelta;
        this.scheduleAlarmFor(pendingIntent, session2, triggerAtMillis, "upcoming_channel_id");
    }

    private final void scheduleAlarmForPostSession(PendingIntent pendingIntent, Session session2) {
        long triggerAtMillis = ExtensionsKt.toEpochMilli(session2.getEndTime()) + alarmTimeDelta;
        this.scheduleAlarmFor(pendingIntent, session2, triggerAtMillis, "feedback_channel_id");
    }

    private final void scheduleAlarmFor(PendingIntent pendingIntent, Session session2, long triggerAtMillis, String channel) {
        block0: {
            AlarmManager alarmManager = this.systemAlarmManager;
            if (alarmManager == null) break block0;
            AlarmManager alarmManager2 = alarmManager;
            boolean bl = false;
            boolean bl2 = false;
            AlarmManager it = alarmManager2;
            boolean bl3 = false;
            AlarmManagerCompat.setExactAndAllowWhileIdle((AlarmManager)this.systemAlarmManager, (int)0, (long)triggerAtMillis, (PendingIntent)pendingIntent);
            Timber.d((String)StringsKt.trimMargin$default((String)("Scheduled alarm for session " + session2.getTitle() + " at " + triggerAtMillis + "\n                |for channel: " + channel), null, (int)1, null), (Object[])new Object[0]);
        }
    }

    public final void dismissNotificationInFiveMinutes(int notificationId) {
        block0: {
            AlarmManager alarmManager = this.systemAlarmManager;
            if (alarmManager == null) break block0;
            AlarmManager alarmManager2 = alarmManager;
            boolean bl = false;
            boolean bl2 = false;
            AlarmManager it = alarmManager2;
            boolean bl3 = false;
            Intent intent = new Intent(this.context, CancelNotificationBroadcastReceiver.class);
            intent.putExtra("notification_id_extra", notificationId);
            PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this.context, (int)notificationId, (Intent)intent, (int)0);
            long triggerAtMillis = Instant.now().plus(5L, (TemporalUnit)ChronoUnit.MINUTES).toEpochMilli();
            AlarmManagerCompat.setExactAndAllowWhileIdle((AlarmManager)this.systemAlarmManager, (int)1, (long)triggerAtMillis, (PendingIntent)pendingIntent);
            Timber.d((String)("Scheduled notification dismissal for " + notificationId + " at " + triggerAtMillis), (Object[])new Object[0]);
        }
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Inject
    public SessionAlarmManager(@ApplicationContext @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context $this$getSystemService$iv = this.context = context;
        boolean $i$f$getSystemService = false;
        this.systemAlarmManager = (AlarmManager)ContextCompat.getSystemService((Context)$this$getSystemService$iv, AlarmManager.class);
    }

    static {
        Companion = new Companion(null);
        alarmTimeDelta = TimeUnit.MINUTES.toMillis(5L);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/google/samples/apps/iosched/shared/notifications/SessionAlarmManager$Companion;", "", "()V", "alarmTimeDelta", "", "shared_staging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

