/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.util;

import androidx.annotation.StringRes;
import com.google.samples.apps.iosched.model.ConferenceDay;
import com.google.samples.apps.iosched.model.Session;
import com.google.samples.apps.iosched.shared.R;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.chrono.ChronoZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;
import org.threeten.bp.temporal.TemporalAccessor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0014J\u000e\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u000fJ\b\u0010\u0019\u001a\u0004\u0018\u00010\tJ\u0006\u0010\u001a\u001a\u00020\u000fJ\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\u0014H\u0007J\u001a\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u000f2\b\b\u0002\u0010\u001e\u001a\u00020\u0014H\u0007J\u001a\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020\u000fJ\u001a\u0010&\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\b\b\u0002\u0010\u001e\u001a\u00020\u0014H\u0007J\u0010\u0010'\u001a\u00020\u00142\b\b\u0002\u0010(\u001a\u00020\u0004J \u0010)\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u000f2\b\b\u0002\u0010+\u001a\u00020\u0014J\u0018\u0010,\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\u000f2\b\b\u0002\u0010(\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006."}, d2={"Lcom/google/samples/apps/iosched/shared/util/TimeUtils;", "", "()V", "CONFERENCE_TIMEZONE", "Lorg/threeten/bp/ZoneId;", "getCONFERENCE_TIMEZONE", "()Lorg/threeten/bp/ZoneId;", "ConferenceDays", "", "Lcom/google/samples/apps/iosched/model/ConferenceDay;", "getConferenceDays", "()Ljava/util/List;", "abbreviatedDayForAr", "", "startTime", "Lorg/threeten/bp/ZonedDateTime;", "abbreviatedTimeForAnnouncements", "abbreviatedTimeForAr", "abbreviatedTimeString", "conferenceHasEnded", "", "conferenceHasStarted", "dateString", "dateTimeString", "getConferenceEndTime", "getCurrentConferenceDay", "getKeynoteStartTime", "getLabelResForDay", "", "day", "inConferenceTimeZone", "getLabelResForTime", "time", "getSessionState", "Lcom/google/samples/apps/iosched/shared/util/TimeUtils$SessionRelativeTimeState;", "session", "Lcom/google/samples/apps/iosched/model/Session;", "currentTime", "getShortLabelResForDay", "isConferenceTimeZone", "zoneId", "timeString", "endTime", "withDate", "zonedTime", "SessionRelativeTimeState", "shared_staging"})
public final class TimeUtils {
    @NotNull
    private static final ZoneId CONFERENCE_TIMEZONE;
    @NotNull
    private static final List<ConferenceDay> ConferenceDays;
    @NotNull
    public static final TimeUtils INSTANCE;

    @NotNull
    public final ZoneId getCONFERENCE_TIMEZONE() {
        return CONFERENCE_TIMEZONE;
    }

    @NotNull
    public final List<ConferenceDay> getConferenceDays() {
        return ConferenceDays;
    }

    @NotNull
    public final SessionRelativeTimeState getSessionState(@Nullable Session session2, @NotNull ZonedDateTime currentTime) {
        Intrinsics.checkNotNullParameter((Object)currentTime, (String)"currentTime");
        return session2 == null ? SessionRelativeTimeState.UNKNOWN : (currentTime.compareTo((ChronoZonedDateTime)session2.getStartTime()) < 0 ? SessionRelativeTimeState.BEFORE : (currentTime.compareTo((ChronoZonedDateTime)session2.getEndTime()) > 0 ? SessionRelativeTimeState.AFTER : SessionRelativeTimeState.DURING));
    }

    public static /* synthetic */ SessionRelativeTimeState getSessionState$default(TimeUtils timeUtils, Session session2, ZonedDateTime zonedDateTime, int n, Object object) {
        if ((n & 2) != 0) {
            ZonedDateTime zonedDateTime2 = ZonedDateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"ZonedDateTime.now()");
            zonedDateTime = zonedDateTime2;
        }
        return timeUtils.getSessionState(session2, zonedDateTime);
    }

    @StringRes
    public final int getLabelResForDay(@NotNull ConferenceDay day, boolean inConferenceTimeZone) {
        int n;
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        ConferenceDay conferenceDay = day;
        if (Intrinsics.areEqual((Object)conferenceDay, (Object)ConferenceDays.get(0))) {
            n = inConferenceTimeZone ? R.string.day1_day_date : R.string.day1;
        } else if (Intrinsics.areEqual((Object)conferenceDay, (Object)ConferenceDays.get(1))) {
            n = inConferenceTimeZone ? R.string.day2_day_date : R.string.day2;
        } else if (Intrinsics.areEqual((Object)conferenceDay, (Object)ConferenceDays.get(2))) {
            n = inConferenceTimeZone ? R.string.day3_day_date : R.string.day3;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown ConferenceDay");
        }
        return n;
    }

    public static /* synthetic */ int getLabelResForDay$default(TimeUtils timeUtils, ConferenceDay conferenceDay, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return timeUtils.getLabelResForDay(conferenceDay, bl);
    }

    @StringRes
    public final int getShortLabelResForDay(@NotNull ConferenceDay day, boolean inConferenceTimeZone) {
        int n;
        Intrinsics.checkNotNullParameter((Object)day, (String)"day");
        ConferenceDay conferenceDay = day;
        if (Intrinsics.areEqual((Object)conferenceDay, (Object)ConferenceDays.get(0))) {
            n = inConferenceTimeZone ? R.string.day1_date : R.string.day1;
        } else if (Intrinsics.areEqual((Object)conferenceDay, (Object)ConferenceDays.get(1))) {
            n = inConferenceTimeZone ? R.string.day2_date : R.string.day2;
        } else if (Intrinsics.areEqual((Object)conferenceDay, (Object)ConferenceDays.get(2))) {
            n = inConferenceTimeZone ? R.string.day3_date : R.string.day3;
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown ConferenceDay");
        }
        return n;
    }

    public static /* synthetic */ int getShortLabelResForDay$default(TimeUtils timeUtils, ConferenceDay conferenceDay, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return timeUtils.getShortLabelResForDay(conferenceDay, bl);
    }

    @StringRes
    public final int getLabelResForTime(@NotNull ZonedDateTime time, boolean inConferenceTimeZone) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return time.isBefore((ChronoZonedDateTime)ConferenceDays.get(0).getStart()) ? (inConferenceTimeZone ? R.string.day0_day_date : R.string.day0) : (time.isBefore((ChronoZonedDateTime)ConferenceDays.get(1).getStart()) ? (inConferenceTimeZone ? R.string.day1_day_date : R.string.day1) : (time.isBefore((ChronoZonedDateTime)ConferenceDays.get(2).getStart()) ? (inConferenceTimeZone ? R.string.day2_day_date : R.string.day2) : (inConferenceTimeZone ? R.string.day3_day_date : R.string.day3)));
    }

    public static /* synthetic */ int getLabelResForTime$default(TimeUtils timeUtils, ZonedDateTime zonedDateTime, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return timeUtils.getLabelResForTime(zonedDateTime, bl);
    }

    @NotNull
    public final ZonedDateTime zonedTime(@NotNull ZonedDateTime time, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant((Instant)time.toInstant(), (ZoneId)zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.ofInstant(time.toInstant(), zoneId)");
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime zonedTime$default(TimeUtils timeUtils, ZonedDateTime zonedDateTime, ZoneId zoneId, int n, Object object) {
        if ((n & 2) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return timeUtils.zonedTime(zonedDateTime, zoneId);
    }

    public final boolean isConferenceTimeZone(@NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        return Intrinsics.areEqual((Object)zoneId, (Object)CONFERENCE_TIMEZONE);
    }

    public static /* synthetic */ boolean isConferenceTimeZone$default(TimeUtils timeUtils, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            ZoneId zoneId2 = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"ZoneId.systemDefault()");
            zoneId = zoneId2;
        }
        return timeUtils.isConferenceTimeZone(zoneId);
    }

    @NotNull
    public final String abbreviatedTimeString(@NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        String string2 = DateTimeFormatter.ofPattern((String)"EEE, MMM d").format((TemporalAccessor)startTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DateTimeFormatter.ofPatt\u2026MMM d\").format(startTime)");
        return string2;
    }

    @NotNull
    public final String dateString(@NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        String string2 = DateTimeFormatter.ofPattern((String)"MMM d").format((TemporalAccessor)startTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DateTimeFormatter.ofPatt\u2026MMM d\").format(startTime)");
        return string2;
    }

    @NotNull
    public final String dateTimeString(@NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        String string2 = DateTimeFormatter.ofPattern((String)"MMM d, h:mm a").format((TemporalAccessor)startTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DateTimeFormatter.ofPatt\u2026:mm a\").format(startTime)");
        return string2;
    }

    @NotNull
    public final String timeString(@NotNull ZonedDateTime startTime, @NotNull ZonedDateTime endTime, boolean withDate) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        StringBuilder sb = new StringBuilder();
        String dateFormat = withDate ? "EEE, MMM d, h:mm " : "h:mm ";
        sb.append(DateTimeFormatter.ofPattern((String)dateFormat).format((TemporalAccessor)startTime));
        String string2 = DateTimeFormatter.ofPattern((String)"a").format((TemporalAccessor)startTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DateTimeFormatter.ofPattern(\"a\").format(startTime)");
        String startTimeMeridiem = string2;
        String string3 = DateTimeFormatter.ofPattern((String)"a").format((TemporalAccessor)endTime);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"DateTimeFormatter.ofPattern(\"a\").format(endTime)");
        String endTimeMeridiem = string3;
        if (Intrinsics.areEqual((Object)startTimeMeridiem, (Object)endTimeMeridiem) ^ true) {
            sb.append(startTimeMeridiem).append(" ");
        }
        sb.append(DateTimeFormatter.ofPattern((String)"- h:mm a").format((TemporalAccessor)endTime));
        String string4 = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"sb.toString()");
        return string4;
    }

    public static /* synthetic */ String timeString$default(TimeUtils timeUtils, ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return timeUtils.timeString(zonedDateTime, zonedDateTime2, bl);
    }

    @NotNull
    public final String abbreviatedDayForAr(@NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        String string2 = DateTimeFormatter.ofPattern((String)"MM/dd").format((TemporalAccessor)startTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DateTimeFormatter.ofPatt\u2026MM/dd\").format(startTime)");
        return string2;
    }

    @NotNull
    public final String abbreviatedTimeForAr(@NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        String string2 = DateTimeFormatter.ofPattern((String)"HH:mm").format((TemporalAccessor)startTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DateTimeFormatter.ofPatt\u2026HH:mm\").format(startTime)");
        return string2;
    }

    @NotNull
    public final String abbreviatedTimeForAnnouncements(@NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        ZonedDateTime now = ZonedDateTime.now((ZoneId)startTime.getZone());
        int n = startTime.getDayOfMonth();
        ZonedDateTime zonedDateTime = now;
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"now");
        String dateFormat = n == zonedDateTime.getDayOfMonth() ? "h:mm a" : "MMM d, h:mm a";
        String string2 = DateTimeFormatter.ofPattern((String)dateFormat).format((TemporalAccessor)startTime);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DateTimeFormatter.ofPatt\u2026Format).format(startTime)");
        return string2;
    }

    public final boolean conferenceHasStarted() {
        return ZonedDateTime.now().isAfter((ChronoZonedDateTime)((ConferenceDay)CollectionsKt.first(ConferenceDays)).getStart());
    }

    public final boolean conferenceHasEnded() {
        return ZonedDateTime.now().isAfter((ChronoZonedDateTime)((ConferenceDay)CollectionsKt.last(ConferenceDays)).getEnd());
    }

    @NotNull
    public final ZonedDateTime getKeynoteStartTime() {
        ZonedDateTime zonedDateTime = ((ConferenceDay)CollectionsKt.first(ConferenceDays)).getStart().plusHours(3L);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ConferenceDays.first().start.plusHours(3L)");
        return zonedDateTime;
    }

    @Nullable
    public final ConferenceDay getCurrentConferenceDay() {
        Object v0;
        block2: {
            ZonedDateTime now = ZonedDateTime.now();
            if (now.isBefore((ChronoZonedDateTime)((ConferenceDay)CollectionsKt.first(ConferenceDays)).getStart())) {
                return null;
            }
            Iterable $this$firstOrNull$iv = ConferenceDays;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ConferenceDay it = (ConferenceDay)element$iv;
                boolean bl = false;
                if (!now.isBefore((ChronoZonedDateTime)it.getEnd())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final ZonedDateTime getConferenceEndTime() {
        return ((ConferenceDay)CollectionsKt.last(ConferenceDays)).getEnd();
    }

    private TimeUtils() {
    }

    static {
        TimeUtils timeUtils;
        INSTANCE = timeUtils = new TimeUtils();
        ZoneId zoneId = ZoneId.of((String)"America/Los_Angeles");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"ZoneId.of(BuildConfig.CONFERENCE_TIMEZONE)");
        CONFERENCE_TIMEZONE = zoneId;
        Object[] objectArray = new ConferenceDay[3];
        ZonedDateTime zonedDateTime = ZonedDateTime.parse((CharSequence)"2019-05-07T07:00:00-07:00");
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"ZonedDateTime.parse(Buil\u2026ig.CONFERENCE_DAY1_START)");
        ZonedDateTime zonedDateTime2 = ZonedDateTime.parse((CharSequence)"2019-05-07T22:00:01-07:00");
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"ZonedDateTime.parse(Buil\u2026nfig.CONFERENCE_DAY1_END)");
        objectArray[0] = new ConferenceDay(zonedDateTime, zonedDateTime2);
        ZonedDateTime zonedDateTime3 = ZonedDateTime.parse((CharSequence)"2019-05-08T08:00:00-07:00");
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime3, (String)"ZonedDateTime.parse(Buil\u2026ig.CONFERENCE_DAY2_START)");
        ZonedDateTime zonedDateTime4 = ZonedDateTime.parse((CharSequence)"2019-05-08T22:00:01-07:00");
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime4, (String)"ZonedDateTime.parse(Buil\u2026nfig.CONFERENCE_DAY2_END)");
        objectArray[1] = new ConferenceDay(zonedDateTime3, zonedDateTime4);
        ZonedDateTime zonedDateTime5 = ZonedDateTime.parse((CharSequence)"2019-05-09T08:00:00-07:00");
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime5, (String)"ZonedDateTime.parse(Buil\u2026ig.CONFERENCE_DAY3_START)");
        ZonedDateTime zonedDateTime6 = ZonedDateTime.parse((CharSequence)"2019-05-09T22:00:00-07:00");
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime6, (String)"ZonedDateTime.parse(Buil\u2026nfig.CONFERENCE_DAY3_END)");
        objectArray[2] = new ConferenceDay(zonedDateTime5, zonedDateTime6);
        ConferenceDays = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/samples/apps/iosched/shared/util/TimeUtils$SessionRelativeTimeState;", "", "(Ljava/lang/String;I)V", "BEFORE", "DURING", "AFTER", "UNKNOWN", "shared_staging"})
    public static final class SessionRelativeTimeState
    extends Enum<SessionRelativeTimeState> {
        public static final /* enum */ SessionRelativeTimeState BEFORE;
        public static final /* enum */ SessionRelativeTimeState DURING;
        public static final /* enum */ SessionRelativeTimeState AFTER;
        public static final /* enum */ SessionRelativeTimeState UNKNOWN;
        private static final /* synthetic */ SessionRelativeTimeState[] $VALUES;

        static {
            SessionRelativeTimeState[] sessionRelativeTimeStateArray = new SessionRelativeTimeState[4];
            SessionRelativeTimeState[] sessionRelativeTimeStateArray2 = sessionRelativeTimeStateArray;
            sessionRelativeTimeStateArray[0] = BEFORE = new SessionRelativeTimeState();
            sessionRelativeTimeStateArray[1] = DURING = new SessionRelativeTimeState();
            sessionRelativeTimeStateArray[2] = AFTER = new SessionRelativeTimeState();
            sessionRelativeTimeStateArray[3] = UNKNOWN = new SessionRelativeTimeState();
            $VALUES = sessionRelativeTimeStateArray;
        }

        public static SessionRelativeTimeState[] values() {
            return (SessionRelativeTimeState[])$VALUES.clone();
        }

        public static SessionRelativeTimeState valueOf(String string2) {
            return Enum.valueOf(SessionRelativeTimeState.class, string2);
        }
    }
}

