/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data;

import android.content.res.Resources;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.samples.apps.iosched.model.ConferenceWifiInfo;
import com.google.samples.apps.iosched.shared.data.config.AppConfigDataSource;
import com.google.samples.apps.iosched.shared.util.TimeUtils;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.format.DateTimeFormatter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0018\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0011\u0010\u001b\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001d"}, d2={"Lcom/google/samples/apps/iosched/shared/data/FakeAppConfigDataSource;", "Lcom/google/samples/apps/iosched/shared/data/config/AppConfigDataSource;", "()V", "times1", "", "", "Landroidx/lifecycle/MutableLiveData;", "times2", "times3", "getStringLiveData", "Landroidx/lifecycle/LiveData;", "key", "getWifiInfo", "Lcom/google/samples/apps/iosched/model/ConferenceWifiInfo;", "initTimes", "", "startTimeDay", "Lorg/threeten/bp/ZonedDateTime;", "times", "isAssistantAppFeatureEnabled", "", "isCodelabsFeatureEnabled", "isExploreArFeatureEnabled", "isMapFeatureEnabled", "isReservationFeatureEnabled", "isSearchScheduleFeatureEnabled", "isSearchUsingRoomFeatureEnabled", "syncStrings", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "shared_staging"})
public final class FakeAppConfigDataSource
implements AppConfigDataSource {
    private final Map<String, MutableLiveData<String>> times1 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"badge_pick_up_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"badge_pick_up_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"badge_pick_up_day0_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"badge_pick_up_day0_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"breakfast_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"breakfast_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"google_keynote_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"google_keynote_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"io_store_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"io_store_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"lunch_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"badge_pick_up_day0_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"lunch_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"developer_keynote_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"developer_keynote_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sessions_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sessions_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"codelabs_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"codelabs_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"office_hours_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"office_hours_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sandboxes_day1_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sandboxes_day1_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"after_dark_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"after_dark_end_time", (Object)new MutableLiveData())});
    private final Map<String, MutableLiveData<String>> times2 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"badge_device_pick_up_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"badge_device_pick_up_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"breakfast_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"breakfast_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"io_store_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"io_store_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"lunch_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"lunch_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sessions_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sessions_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"codelabs_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"codelabs_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"office_hours_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"office_hours_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sandboxes_day2_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sandboxes_day2_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"concert_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"concert_end_time", (Object)new MutableLiveData())});
    private final Map<String, MutableLiveData<String>> times3 = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"badge_device_pick_up_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"badge_device_pick_up_day3_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"breakfast_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"breakfast_day3_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"io_store_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"io_store_day3_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"lunch_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"lunch_day3_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sessions_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sessions_day3_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"codelabs_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"codelabs_day3_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"office_hours_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"office_hours_day3_end_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sandboxes_day3_start_time", (Object)new MutableLiveData()), TuplesKt.to((Object)"sandboxes_day3_end_time", (Object)new MutableLiveData())});

    /*
     * WARNING - void declaration
     */
    private final void initTimes(ZonedDateTime startTimeDay, Map<String, ? extends MutableLiveData<String>> times) {
        Iterable $this$forEachIndexed$iv = times.values();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void mutableLiveData;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            MutableLiveData mutableLiveData2 = (MutableLiveData)item$iv;
            int index = n2;
            boolean bl2 = false;
            mutableLiveData.setValue((Object)startTimeDay.plusMinutes((long)index).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }

    @Override
    @NotNull
    public LiveData<String> getStringLiveData(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        MutableLiveData<String> mutableLiveData = this.times1.get(key);
        LiveData liveData = mutableLiveData != null ? (LiveData)mutableLiveData : (LiveData)this.times2.get(key);
        if (liveData == null) {
            liveData = (LiveData)this.times3.get(key);
        }
        if (liveData == null) {
            throw (Throwable)new Resources.NotFoundException("Value for " + key + " not found");
        }
        return liveData;
    }

    @Override
    @Nullable
    public Object syncStrings(@NotNull Continuation<? super Unit> $completion) {
        return Unit.INSTANCE;
    }

    @Override
    @NotNull
    public ConferenceWifiInfo getWifiInfo() {
        return new ConferenceWifiInfo("", "");
    }

    @Override
    public boolean isMapFeatureEnabled() {
        return true;
    }

    @Override
    public boolean isExploreArFeatureEnabled() {
        return true;
    }

    @Override
    public boolean isCodelabsFeatureEnabled() {
        return true;
    }

    @Override
    public boolean isSearchScheduleFeatureEnabled() {
        return true;
    }

    @Override
    public boolean isSearchUsingRoomFeatureEnabled() {
        return true;
    }

    @Override
    public boolean isAssistantAppFeatureEnabled() {
        return false;
    }

    @Override
    public boolean isReservationFeatureEnabled() {
        return false;
    }

    public FakeAppConfigDataSource() {
        ZonedDateTime startTimeDay1 = TimeUtils.INSTANCE.getConferenceDays().get(0).getStart();
        this.initTimes(startTimeDay1, this.times1);
        ZonedDateTime startTimeDay2 = TimeUtils.INSTANCE.getConferenceDays().get(1).getStart();
        this.initTimes(startTimeDay2, this.times2);
        ZonedDateTime startTimeDay3 = TimeUtils.INSTANCE.getConferenceDays().get(2).getStart();
        this.initTimes(startTimeDay3, this.times3);
    }
}

