/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data.feed;

import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.Timestamp;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.QuerySnapshot;
import com.google.samples.apps.iosched.model.Announcement;
import com.google.samples.apps.iosched.shared.data.FirestoreExtensionsKt;
import com.google.samples.apps.iosched.shared.data.feed.AnnouncementDataSource;
import com.google.samples.apps.iosched.shared.util.ColorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.threeten.bp.Instant;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lcom/google/samples/apps/iosched/shared/data/feed/FirestoreAnnouncementDataSource;", "Lcom/google/samples/apps/iosched/shared/data/feed/AnnouncementDataSource;", "firestore", "Lcom/google/firebase/firestore/FirebaseFirestore;", "(Lcom/google/firebase/firestore/FirebaseFirestore;)V", "getFirestore", "()Lcom/google/firebase/firestore/FirebaseFirestore;", "getAnnouncements", "", "Lcom/google/samples/apps/iosched/model/Announcement;", "parseFeedItem", "snapshot", "Lcom/google/firebase/firestore/DocumentSnapshot;", "Companion", "shared_staging"})
public final class FirestoreAnnouncementDataSource
implements AnnouncementDataSource {
    @NotNull
    private final FirebaseFirestore firestore;
    private static final String FEED_COLLECTION = "feed";
    private static final String ACTIVE = "active";
    private static final String CATEGORY = "category";
    private static final String COLOR = "color";
    private static final String TIMESTAMP = "timeStamp";
    private static final String IMAGE_URL = "imageUrl";
    private static final String MESSAGE = "message";
    private static final String PRIORITY = "priority";
    private static final String TITLE = "title";
    private static final String EMERGENCY = "emergency";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Announcement> getAnnouncements() {
        Comparator comparator;
        Iterable iterable;
        void $this$mapTo$iv$iv;
        QuerySnapshot snapshot;
        Task task = FirestoreExtensionsKt.document2020(this.firestore).collection(FEED_COLLECTION).whereEqualTo(ACTIVE, (Object)true).get();
        Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"firestore\n            .d\u2026 true)\n            .get()");
        Task task2 = task;
        QuerySnapshot querySnapshot = snapshot = (QuerySnapshot)Tasks.await((Task)task2, (long)20L, (TimeUnit)TimeUnit.SECONDS);
        Intrinsics.checkExpressionValueIsNotNull((Object)querySnapshot, (String)"snapshot");
        List list = querySnapshot.getDocuments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"snapshot.documents");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DocumentSnapshot documentSnapshot = (DocumentSnapshot)item$iv$iv;
            iterable = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
            comparator = this.parseFeedItem((DocumentSnapshot)v3);
            iterable.add(comparator);
        }
        iterable = (List)destination$iv$iv;
        boolean bl = false;
        Comparator comparator2 = comparator = (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Announcement it = (Announcement)b;
                boolean bl2 = false;
                Comparable comparable = Boolean.valueOf(it.getPriority());
                it = (Announcement)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Boolean bl3 = it.getPriority();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)bl3);
            }
        };
        boolean bl2 = false;
        comparator = new Comparator<T>(comparator2){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = comparator;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    boolean bl = false;
                    Announcement it = (Announcement)b;
                    boolean bl2 = false;
                    Comparable comparable = (Comparable)it.getTimestamp();
                    it = (Announcement)a;
                    Comparable comparable2 = comparable;
                    bl2 = false;
                    ZonedDateTime zonedDateTime = it.getTimestamp();
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)zonedDateTime));
                }
                return n;
            }
        };
        return CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
    }

    private final Announcement parseFeedItem(DocumentSnapshot snapshot) {
        String string2;
        String string3;
        Object object;
        String string4;
        Object object2;
        String string5;
        String string6 = snapshot.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"snapshot.id");
        Object object3 = snapshot.get(TITLE);
        if (!(object3 instanceof String)) {
            object3 = null;
        }
        if ((string5 = (String)object3) == null) {
            string5 = "";
        }
        if (!((object2 = snapshot.get(CATEGORY)) instanceof String)) {
            object2 = null;
        }
        if ((string4 = (String)object2) == null) {
            string4 = "";
        }
        if (!((object = snapshot.get(IMAGE_URL)) instanceof String)) {
            object = null;
        }
        String string7 = (String)object;
        Object object4 = snapshot.get(MESSAGE);
        if (!(object4 instanceof String)) {
            object4 = null;
        }
        if ((string3 = (String)object4) == null) {
            string3 = "";
        }
        Object object5 = snapshot.get(TIMESTAMP);
        if (object5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.google.firebase.Timestamp");
        }
        ZonedDateTime zonedDateTime = Instant.ofEpochSecond((long)((Timestamp)object5).getSeconds()).atZone((ZoneId)ZoneOffset.UTC);
        Intrinsics.checkExpressionValueIsNotNull((Object)zonedDateTime, (String)"Instant.ofEpochSecond(\n \u2026            ).atZone(UTC)");
        Object object6 = snapshot.get(COLOR);
        if (!(object6 instanceof String)) {
            object6 = null;
        }
        if ((string2 = (String)object6) == null) {
            string2 = "";
        }
        int n = ColorUtils.INSTANCE.parseHexColor(string2);
        Object object7 = snapshot.get(PRIORITY);
        if (!(object7 instanceof Boolean)) {
            object7 = null;
        }
        Boolean bl = (Boolean)object7;
        boolean bl2 = bl != null ? bl : false;
        Object object8 = snapshot.get(EMERGENCY);
        if (!(object8 instanceof Boolean)) {
            object8 = null;
        }
        Boolean bl3 = (Boolean)object8;
        boolean bl4 = bl3 != null ? bl3 : false;
        boolean bl5 = bl2;
        int n2 = n;
        ZonedDateTime zonedDateTime2 = zonedDateTime;
        String string8 = string3;
        String string9 = string7;
        String string10 = string4;
        return new Announcement(string6, string5, string8, bl5, bl4, zonedDateTime2, string9, string10, n2);
    }

    @NotNull
    public final FirebaseFirestore getFirestore() {
        return this.firestore;
    }

    @Inject
    public FirestoreAnnouncementDataSource(@NotNull FirebaseFirestore firestore) {
        Intrinsics.checkParameterIsNotNull((Object)firestore, (String)"firestore");
        this.firestore = firestore;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/samples/apps/iosched/shared/data/feed/FirestoreAnnouncementDataSource$Companion;", "", "()V", "ACTIVE", "", "CATEGORY", "COLOR", "EMERGENCY", "FEED_COLLECTION", "IMAGE_URL", "MESSAGE", "PRIORITY", "TIMESTAMP", "TITLE", "shared_staging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

