/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.di;

import com.google.samples.apps.iosched.shared.data.ConferenceDataRepository;
import com.google.samples.apps.iosched.shared.data.ConferenceDataSource;
import com.google.samples.apps.iosched.shared.data.FakeAnnouncementDataSource;
import com.google.samples.apps.iosched.shared.data.FakeAppConfigDataSource;
import com.google.samples.apps.iosched.shared.data.FakeConferenceDataSource;
import com.google.samples.apps.iosched.shared.data.FakeFeedbackEndpoint;
import com.google.samples.apps.iosched.shared.data.ar.ArDebugFlagEndpoint;
import com.google.samples.apps.iosched.shared.data.ar.FakeArDebugFlagEndpoint;
import com.google.samples.apps.iosched.shared.data.config.AppConfigDataSource;
import com.google.samples.apps.iosched.shared.data.db.AppDatabase;
import com.google.samples.apps.iosched.shared.data.feed.AnnouncementDataSource;
import com.google.samples.apps.iosched.shared.data.feed.DefaultFeedRepository;
import com.google.samples.apps.iosched.shared.data.feed.FakeMomentDataSource;
import com.google.samples.apps.iosched.shared.data.feed.FeedRepository;
import com.google.samples.apps.iosched.shared.data.feed.MomentDataSource;
import com.google.samples.apps.iosched.shared.data.feedback.FeedbackEndpoint;
import com.google.samples.apps.iosched.shared.data.session.DefaultSessionRepository;
import com.google.samples.apps.iosched.shared.data.session.SessionRepository;
import com.google.samples.apps.iosched.shared.data.userevent.DefaultSessionAndUserEventRepository;
import com.google.samples.apps.iosched.shared.data.userevent.FakeUserEventDataSource;
import com.google.samples.apps.iosched.shared.data.userevent.SessionAndUserEventRepository;
import com.google.samples.apps.iosched.shared.data.userevent.UserEventDataSource;
import com.google.samples.apps.iosched.shared.di.SearchUsingRoomEnabledFlag;
import com.google.samples.apps.iosched.shared.domain.search.FtsMatchStrategy;
import com.google.samples.apps.iosched.shared.domain.search.SessionTextMatchStrategy;
import com.google.samples.apps.iosched.shared.domain.search.SimpleMatchStrategy;
import com.google.samples.apps.iosched.shared.fcm.StagingTopicSubscriber;
import com.google.samples.apps.iosched.shared.fcm.TopicSubscriber;
import com.google.samples.apps.iosched.shared.time.DefaultTimeProvider;
import com.google.samples.apps.iosched.shared.time.TimeProvider;
import dagger.Module;
import dagger.Provides;
import dagger.hilt.InstallIn;
import dagger.hilt.android.components.ApplicationComponent;
import javax.inject.Named;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Module
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007J\b\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0007J\b\u0010\t\u001a\u00020\nH\u0007J$\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\n2\b\b\u0001\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010\u0011\u001a\u00020\nH\u0007J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\b\u0010\u0017\u001a\u00020\u0018H\u0007J\b\u0010\u0019\u001a\u00020\u0016H\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\fH\u0007J\u001a\u0010\"\u001a\u00020#2\b\b\u0001\u0010$\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\b\u0010&\u001a\u00020'H\u0007J\b\u0010(\u001a\u00020)H\u0007J\b\u0010*\u001a\u00020\u001dH\u0007\u00a8\u0006+"}, d2={"Lcom/google/samples/apps/iosched/shared/di/SharedModule;", "", "()V", "provideAnnouncementDataSource", "Lcom/google/samples/apps/iosched/shared/data/feed/AnnouncementDataSource;", "provideAppConfigDataSource", "Lcom/google/samples/apps/iosched/shared/data/config/AppConfigDataSource;", "provideArDebugFlagEndpoint", "Lcom/google/samples/apps/iosched/shared/data/ar/ArDebugFlagEndpoint;", "provideBootstrapRemoteSessionDataSource", "Lcom/google/samples/apps/iosched/shared/data/ConferenceDataSource;", "provideConferenceDataRepository", "Lcom/google/samples/apps/iosched/shared/data/ConferenceDataRepository;", "remoteDataSource", "boostrapDataSource", "appDatabase", "Lcom/google/samples/apps/iosched/shared/data/db/AppDatabase;", "provideConferenceDataSource", "provideFeedRepository", "Lcom/google/samples/apps/iosched/shared/data/feed/FeedRepository;", "announcementDataSource", "momentDataSource", "Lcom/google/samples/apps/iosched/shared/data/feed/MomentDataSource;", "provideFeedbackEndpoint", "Lcom/google/samples/apps/iosched/shared/data/feedback/FeedbackEndpoint;", "provideMomentDataSource", "provideSessionAndUserEventRepository", "Lcom/google/samples/apps/iosched/shared/data/userevent/SessionAndUserEventRepository;", "userEventDataSource", "Lcom/google/samples/apps/iosched/shared/data/userevent/UserEventDataSource;", "sessionRepository", "Lcom/google/samples/apps/iosched/shared/data/session/SessionRepository;", "provideSessionRepository", "conferenceDataRepository", "provideSessionTextMatchStrategy", "Lcom/google/samples/apps/iosched/shared/domain/search/SessionTextMatchStrategy;", "useRoom", "", "provideTimeProvider", "Lcom/google/samples/apps/iosched/shared/time/TimeProvider;", "provideTopicSubscriber", "Lcom/google/samples/apps/iosched/shared/fcm/TopicSubscriber;", "provideUserEventDataSource", "shared_staging"})
@InstallIn(value={ApplicationComponent.class})
public final class SharedModule {
    @Singleton
    @Provides
    @Named(value="remoteConfDatasource")
    @NotNull
    public final ConferenceDataSource provideConferenceDataSource() {
        return FakeConferenceDataSource.INSTANCE;
    }

    @Singleton
    @Provides
    @Named(value="bootstrapConfDataSource")
    @NotNull
    public final ConferenceDataSource provideBootstrapRemoteSessionDataSource() {
        return FakeConferenceDataSource.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final ConferenceDataRepository provideConferenceDataRepository(@Named(value="remoteConfDatasource") @NotNull ConferenceDataSource remoteDataSource, @Named(value="bootstrapConfDataSource") @NotNull ConferenceDataSource boostrapDataSource, @NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)remoteDataSource, (String)"remoteDataSource");
        Intrinsics.checkParameterIsNotNull((Object)boostrapDataSource, (String)"boostrapDataSource");
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"appDatabase");
        return new ConferenceDataRepository(remoteDataSource, boostrapDataSource, appDatabase);
    }

    @Singleton
    @Provides
    @NotNull
    public final SessionRepository provideSessionRepository(@NotNull ConferenceDataRepository conferenceDataRepository) {
        Intrinsics.checkParameterIsNotNull((Object)conferenceDataRepository, (String)"conferenceDataRepository");
        return new DefaultSessionRepository(conferenceDataRepository);
    }

    @Singleton
    @Provides
    @NotNull
    public final UserEventDataSource provideUserEventDataSource() {
        return FakeUserEventDataSource.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final FeedbackEndpoint provideFeedbackEndpoint() {
        return FakeFeedbackEndpoint.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final SessionAndUserEventRepository provideSessionAndUserEventRepository(@NotNull UserEventDataSource userEventDataSource, @NotNull SessionRepository sessionRepository) {
        Intrinsics.checkParameterIsNotNull((Object)userEventDataSource, (String)"userEventDataSource");
        Intrinsics.checkParameterIsNotNull((Object)sessionRepository, (String)"sessionRepository");
        return new DefaultSessionAndUserEventRepository(userEventDataSource, sessionRepository);
    }

    @Singleton
    @Provides
    @NotNull
    public final TopicSubscriber provideTopicSubscriber() {
        return new StagingTopicSubscriber();
    }

    @Singleton
    @Provides
    @NotNull
    public final AppConfigDataSource provideAppConfigDataSource() {
        return new FakeAppConfigDataSource();
    }

    @Singleton
    @Provides
    @NotNull
    public final TimeProvider provideTimeProvider() {
        return DefaultTimeProvider.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final AnnouncementDataSource provideAnnouncementDataSource() {
        return FakeAnnouncementDataSource.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final MomentDataSource provideMomentDataSource() {
        return FakeMomentDataSource.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final FeedRepository provideFeedRepository(@NotNull AnnouncementDataSource announcementDataSource, @NotNull MomentDataSource momentDataSource) {
        Intrinsics.checkParameterIsNotNull((Object)announcementDataSource, (String)"announcementDataSource");
        Intrinsics.checkParameterIsNotNull((Object)momentDataSource, (String)"momentDataSource");
        return new DefaultFeedRepository(announcementDataSource, momentDataSource);
    }

    @Singleton
    @Provides
    @NotNull
    public final ArDebugFlagEndpoint provideArDebugFlagEndpoint() {
        return FakeArDebugFlagEndpoint.INSTANCE;
    }

    @Singleton
    @Provides
    @NotNull
    public final SessionTextMatchStrategy provideSessionTextMatchStrategy(@SearchUsingRoomEnabledFlag boolean useRoom, @NotNull AppDatabase appDatabase) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)appDatabase), (String)"appDatabase");
        return useRoom ? (SessionTextMatchStrategy)new FtsMatchStrategy(appDatabase) : (SessionTextMatchStrategy)SimpleMatchStrategy.INSTANCE;
    }
}

