/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.domain.sessions;

import com.google.samples.apps.iosched.model.ConferenceDay;
import com.google.samples.apps.iosched.model.userdata.UserSession;
import com.google.samples.apps.iosched.shared.data.userevent.DefaultSessionAndUserEventRepository;
import com.google.samples.apps.iosched.shared.data.userevent.ObservableUserEvents;
import com.google.samples.apps.iosched.shared.di.IoDispatcher;
import com.google.samples.apps.iosched.shared.domain.FlowUseCase;
import com.google.samples.apps.iosched.shared.domain.sessions.ConferenceDayIndexer;
import com.google.samples.apps.iosched.shared.domain.sessions.LoadScheduleUserSessionsParameters;
import com.google.samples.apps.iosched.shared.domain.sessions.LoadScheduleUserSessionsResult;
import com.google.samples.apps.iosched.shared.domain.sessions.LoadScheduleUserSessionsUseCase;
import com.google.samples.apps.iosched.shared.domain.sessions.LoadScheduleUserSessionsUseCase$execute$;
import com.google.samples.apps.iosched.shared.result.Result;
import com.google.samples.apps.iosched.shared.util.TimeUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.chrono.ChronoZonedDateTime;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0001\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001c\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadScheduleUserSessionsUseCase;", "Lcom/google/samples/apps/iosched/shared/domain/FlowUseCase;", "Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadScheduleUserSessionsParameters;", "Lcom/google/samples/apps/iosched/shared/domain/sessions/LoadScheduleUserSessionsResult;", "userEventRepository", "Lcom/google/samples/apps/iosched/shared/data/userevent/DefaultSessionAndUserEventRepository;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Lcom/google/samples/apps/iosched/shared/data/userevent/DefaultSessionAndUserEventRepository;Lkotlinx/coroutines/CoroutineDispatcher;)V", "buildConferenceDayIndexer", "Lcom/google/samples/apps/iosched/shared/domain/sessions/ConferenceDayIndexer;", "sessions", "", "Lcom/google/samples/apps/iosched/model/userdata/UserSession;", "execute", "Lkotlinx/coroutines/flow/Flow;", "Lcom/google/samples/apps/iosched/shared/result/Result;", "parameters", "findFirstUnfinishedSession", "", "userSessions", "now", "Lorg/threeten/bp/ZonedDateTime;", "shared_staging"})
public class LoadScheduleUserSessionsUseCase
extends FlowUseCase<LoadScheduleUserSessionsParameters, LoadScheduleUserSessionsResult> {
    private final DefaultSessionAndUserEventRepository userEventRepository;

    @Override
    @NotNull
    protected Flow<Result<LoadScheduleUserSessionsResult>> execute(@NotNull LoadScheduleUserSessionsParameters parameters) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Timber.d((String)"LoadFilteredUserSessionsUseCase: Refreshing sessions with user data", (Object[])new Object[0]);
        Flow<Result<ObservableUserEvents>> $this$map$iv = this.userEventRepository.getObservableUserEvents(parameters.getUserId());
        boolean $i$f$map = false;
        Flow<Result<ObservableUserEvents>> $this$unsafeTransform$iv$iv = $this$map$iv;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        return (Flow)new Flow<Result<? extends LoadScheduleUserSessionsResult>>($this$unsafeTransform$iv$iv, this, parameters){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            final /* synthetic */ LoadScheduleUserSessionsUseCase this$0;
            final /* synthetic */ LoadScheduleUserSessionsParameters $parameters$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
                this.this$0 = loadScheduleUserSessionsUseCase;
                this.$parameters$inlined = loadScheduleUserSessionsParameters;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public Object collect(@NotNull FlowCollector flowCollector, @NotNull Continuation $completion) {
                void $this$collect$iv;
                void collector;
                Continuation continuation = $completion;
                void $receiver = collector;
                boolean bl = false;
                Flow flow = this.$this_unsafeTransform$inlined;
                Continuation continuation2 = $completion;
                boolean $i$f$collect = false;
                Object object = $this$collect$iv.collect((FlowCollector)new FlowCollector<Result<? extends ObservableUserEvents>>((FlowCollector)$receiver, this){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    final /* synthetic */ execute$$inlined$map$1 this$0;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                        this.this$0 = var2_2;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public Object emit(Object object, @NotNull Continuation $completion) {
                        Result result;
                        void result2;
                        void value;
                        void value2;
                        Continuation continuation = $completion;
                        void value3 = value2;
                        boolean bl = false;
                        Continuation continuation2 = $completion;
                        void var7_7 = value3;
                        FlowCollector $receiver = this.$this_unsafeFlow$inlined;
                        boolean bl2 = false;
                        Continuation continuation3 = $completion;
                        Result result3 = (Result)value;
                        FlowCollector flowCollector = $receiver;
                        boolean bl3 = false;
                        void var14_14 = result2;
                        if (var14_14 instanceof Result.Success) {
                            List sortedSessions2 = CollectionsKt.sortedWith((Iterable)((ObservableUserEvents)((Result.Success)result2).getData()).getUserSessions(), (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{execute.1.sortedSessions.1.INSTANCE, execute.1.sortedSessions.2.INSTANCE}));
                            Iterable $this$forEach$iv = sortedSessions2;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                UserSession it = (UserSession)element$iv;
                                boolean bl4 = false;
                                it.getSession().getType();
                            }
                            LoadScheduleUserSessionsResult usecaseResult = new LoadScheduleUserSessionsResult(sortedSessions2, ((ObservableUserEvents)((Result.Success)result2).getData()).getUserMessage(), ((ObservableUserEvents)((Result.Success)result2).getData()).getUserMessageSession(), sortedSessions2.size(), LoadScheduleUserSessionsUseCase.access$findFirstUnfinishedSession(this.this$0.this$0, sortedSessions2, this.this$0.$parameters$inlined.getNow()), LoadScheduleUserSessionsUseCase.access$buildConferenceDayIndexer(this.this$0.this$0, sortedSessions2));
                            result = new Result.Success<LoadScheduleUserSessionsResult>(usecaseResult);
                        } else if (var14_14 instanceof Result.Error) {
                            result = new Result.Error(((Result.Error)result2).getException());
                        } else if (var14_14 instanceof Result.Loading) {
                            result = Result.Loading.INSTANCE;
                        } else {
                            throw new NoWhenBranchMatchedException();
                        }
                        Result result4 = result;
                        Object object2 = flowCollector.emit((Object)result4, $completion);
                        if (object2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object2;
                        }
                        return Unit.INSTANCE;
                    }
                }, continuation2);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
    }

    private final int findFirstUnfinishedSession(List<UserSession> userSessions, ZonedDateTime now) {
        if (now.isAfter((ChronoZonedDateTime)((ConferenceDay)CollectionsKt.first(TimeUtils.INSTANCE.getConferenceDays())).getStart()) && now.isBefore((ChronoZonedDateTime)((ConferenceDay)CollectionsKt.last(TimeUtils.INSTANCE.getConferenceDays())).getEnd())) {
            int n;
            block3: {
                List<UserSession> $this$indexOfFirst$iv = userSessions;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<UserSession> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    UserSession item$iv;
                    UserSession it = item$iv = iterator.next();
                    boolean bl = false;
                    if (it.getSession().getEndTime().isAfter((ChronoZonedDateTime)now)) {
                        n = index$iv;
                        break block3;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final ConferenceDayIndexer buildConferenceDayIndexer(List<UserSession> sessions) {
        Iterable $this$associateWith$iv = TimeUtils.INSTANCE.getConferenceDays();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object t : $this$associateWithTo$iv$iv) {
            int n;
            Map map2;
            Object t2;
            block4: {
                ConferenceDay conferenceDay = (ConferenceDay)t;
                t2 = t;
                map2 = result$iv;
                boolean bl = false;
                List<UserSession> $this$indexOfFirst$iv = sessions;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<UserSession> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    void day;
                    UserSession item$iv;
                    UserSession it = item$iv = iterator.next();
                    boolean bl2 = false;
                    if (day.contains(it.getSession())) {
                        n = index$iv;
                        break block4;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            Integer n2 = n;
            map2.put(t2, n2);
        }
        Map $this$filterValues$iv = result$iv;
        boolean $i$f$filterValues = false;
        result$iv = new LinkedHashMap();
        Map map3 = $this$filterValues$iv;
        boolean bl = false;
        for (Map.Entry entry : map3.entrySet()) {
            int it = ((Number)entry.getValue()).intValue();
            boolean bl3 = false;
            if (!(it >= 0)) continue;
            result$iv.put(entry.getKey(), entry.getValue());
        }
        Map mapping = result$iv;
        return new ConferenceDayIndexer(mapping);
    }

    @Inject
    public LoadScheduleUserSessionsUseCase(@NotNull DefaultSessionAndUserEventRepository userEventRepository, @IoDispatcher @NotNull CoroutineDispatcher dispatcher) {
        Intrinsics.checkParameterIsNotNull((Object)userEventRepository, (String)"userEventRepository");
        Intrinsics.checkParameterIsNotNull((Object)dispatcher, (String)"dispatcher");
        super(dispatcher);
        this.userEventRepository = userEventRepository;
    }

    public static final /* synthetic */ int access$findFirstUnfinishedSession(LoadScheduleUserSessionsUseCase $this, List userSessions, ZonedDateTime now) {
        return $this.findFirstUnfinishedSession(userSessions, now);
    }

    public static final /* synthetic */ ConferenceDayIndexer access$buildConferenceDayIndexer(LoadScheduleUserSessionsUseCase $this, List sessions) {
        return $this.buildConferenceDayIndexer(sessions);
    }
}

