/*
 * Decompiled with CFR 0.152.
 */
package com.google.samples.apps.iosched.shared.data.userevent;

import com.google.firebase.firestore.DocumentSnapshot;
import com.google.samples.apps.iosched.model.reservations.ReservationRequest;
import com.google.samples.apps.iosched.model.reservations.ReservationRequestResult;
import com.google.samples.apps.iosched.model.userdata.UserEvent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"generateReservationRequestResult", "Lcom/google/samples/apps/iosched/model/reservations/ReservationRequestResult;", "snapshot", "Lcom/google/firebase/firestore/DocumentSnapshot;", "parseReservationRequest", "Lcom/google/samples/apps/iosched/model/reservations/ReservationRequest;", "parseUserEvent", "Lcom/google/samples/apps/iosched/model/userdata/UserEvent;", "shared_release"})
public final class FirestoreUserEventParserKt {
    @NotNull
    public static final UserEvent parseUserEvent(@NotNull DocumentSnapshot snapshot) {
        UserEvent.ReservationStatus reservationStatus;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)snapshot, (String)"snapshot");
        ReservationRequestResult reservationRequestResult = FirestoreUserEventParserKt.generateReservationRequestResult(snapshot);
        ReservationRequest reservationRequest = FirestoreUserEventParserKt.parseReservationRequest(snapshot);
        Object object = snapshot.get("reservationStatus");
        if (!(object instanceof String)) {
            object = null;
        }
        String string = (String)object;
        if (string != null) {
            String string2 = string;
            boolean bl2 = false;
            bl = false;
            String it = string2;
            boolean bl3 = false;
            reservationStatus = UserEvent.ReservationStatus.Companion.getIfPresent(it);
        } else {
            reservationStatus = null;
        }
        UserEvent.ReservationStatus reservationStatus2 = reservationStatus;
        String string3 = snapshot.getId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"snapshot.id");
        Object object2 = snapshot.get("isStarred");
        if (!(object2 instanceof Boolean)) {
            object2 = null;
        }
        Boolean bl4 = (Boolean)object2;
        boolean bl5 = bl4 != null ? bl4 : false;
        Object object3 = snapshot.get("reviewed");
        if (!(object3 instanceof Boolean)) {
            object3 = null;
        }
        Boolean bl6 = (Boolean)object3;
        boolean bl7 = bl6 != null ? bl6 : false;
        ReservationRequest reservationRequest2 = reservationRequest;
        bl = bl5;
        UserEvent.ReservationStatus reservationStatus3 = reservationStatus2;
        ReservationRequestResult reservationRequestResult2 = reservationRequestResult;
        return new UserEvent(string3, bl, bl7, reservationStatus3, reservationRequestResult2, reservationRequest2);
    }

    private static final ReservationRequestResult generateReservationRequestResult(DocumentSnapshot snapshot) {
        Object object = snapshot.get("reservationResult");
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map2 = (Map)object;
        if (map2 != null) {
            long timestamp;
            ReservationRequestResult.ReservationRequestStatus reservationRequestStatus;
            Map map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map reservation = map3;
            boolean bl3 = false;
            Object object2 = reservation;
            String string = "requestResult";
            boolean bl4 = false;
            Object v = object2.get(string);
            if (!(v instanceof String)) {
                v = null;
            }
            String string2 = (String)v;
            if (string2 != null) {
                object2 = string2;
                boolean bl5 = false;
                bl4 = false;
                Object it = object2;
                boolean bl6 = false;
                reservationRequestStatus = ReservationRequestResult.ReservationRequestStatus.Companion.getIfPresent((String)it);
            } else {
                reservationRequestStatus = null;
            }
            ReservationRequestResult.ReservationRequestStatus requestResult = reservationRequestStatus;
            Map map4 = reservation;
            String string3 = "requestId";
            boolean bl7 = false;
            Object v2 = map4.get(string3);
            if (!(v2 instanceof String)) {
                v2 = null;
            }
            String requestId = (String)v2;
            Map map5 = reservation;
            String string4 = "timestamp";
            boolean bl8 = false;
            Object v3 = map5.get(string4);
            if (!(v3 instanceof Long)) {
                v3 = null;
            }
            Long l = (Long)v3;
            long l2 = timestamp = l != null ? l : -1L;
            if (requestResult == null || requestId == null) {
                Timber.e((String)"Error parsing reservation request result: some fields null", (Object[])new Object[0]);
                return null;
            }
            return new ReservationRequestResult(requestResult, requestId, timestamp);
        }
        return null;
    }

    private static final ReservationRequest parseReservationRequest(DocumentSnapshot snapshot) {
        Object object = snapshot.get("reservationRequest");
        if (!(object instanceof Map)) {
            object = null;
        }
        Map map2 = (Map)object;
        if (map2 != null) {
            ReservationRequest.ReservationRequestEntityAction reservationRequestEntityAction;
            Map map3 = map2;
            boolean bl = false;
            boolean bl2 = false;
            Map request = map3;
            boolean bl3 = false;
            Object object2 = request;
            String string = "action";
            boolean bl4 = false;
            Object v = object2.get(string);
            if (!(v instanceof String)) {
                v = null;
            }
            String string2 = (String)v;
            if (string2 != null) {
                object2 = string2;
                boolean bl5 = false;
                bl4 = false;
                Object it = object2;
                boolean bl6 = false;
                reservationRequestEntityAction = ReservationRequest.ReservationRequestEntityAction.Companion.getIfPresent((String)it);
            } else {
                reservationRequestEntityAction = null;
            }
            ReservationRequest.ReservationRequestEntityAction action = reservationRequestEntityAction;
            Map map4 = request;
            String string3 = "requestId";
            boolean bl7 = false;
            Object v2 = map4.get(string3);
            if (!(v2 instanceof String)) {
                v2 = null;
            }
            String requestId = (String)v2;
            if (action == null || requestId == null) {
                Timber.e((String)"Error parsing reservation request from Firestore", (Object[])new Object[0]);
                return null;
            }
            return new ReservationRequest(action, requestId);
        }
        return null;
    }
}

